/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.json.JsonData;

public class Debot {
    public static CompletableFuture<Void> start(@NonNull Context context, @NonNull Integer debotHandle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (debotHandle == null) {
            throw new NullPointerException("debotHandle is marked non-null but is null");
        }
        return context.future("debot.start", new ParamsOfStart(debotHandle), Void.class);
    }

    public static CompletableFuture<ResultOfFetch> fetch(@NonNull Context context, @NonNull String address) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return context.future("debot.fetch", new ParamsOfFetch(address), ResultOfFetch.class);
    }

    public static CompletableFuture<Void> execute(@NonNull Context context, @NonNull Integer debotHandle, @NonNull DebotAction action) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (debotHandle == null) {
            throw new NullPointerException("debotHandle is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        return context.future("debot.execute", new ParamsOfExecute(debotHandle, action), Void.class);
    }

    public static CompletableFuture<Void> send(@NonNull Context context, @NonNull Integer debotHandle, @NonNull String message) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (debotHandle == null) {
            throw new NullPointerException("debotHandle is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return context.future("debot.send", new ParamsOfSend(debotHandle, message), Void.class);
    }

    public static CompletableFuture<Void> remove(@NonNull Context context, @NonNull Integer debotHandle) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (debotHandle == null) {
            throw new NullPointerException("debotHandle is marked non-null but is null");
        }
        return context.future("debot.remove", new ParamsOfRemove(debotHandle), Void.class);
    }

    public static final class ParamsOfStart
    extends JsonData {
        @SerializedName(value="debot_handle")
        @NonNull
        private final Integer debotHandle;

        @Generated
        public ParamsOfStart(@NonNull Integer debotHandle) {
            if (debotHandle == null) {
                throw new NullPointerException("debotHandle is marked non-null but is null");
            }
            this.debotHandle = debotHandle;
        }

        @NonNull
        @Generated
        public Integer debotHandle() {
            return this.debotHandle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfStart)) {
                return false;
            }
            ParamsOfStart other = (ParamsOfStart)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$debotHandle = this.debotHandle();
            Integer other$debotHandle = other.debotHandle();
            return !(this$debotHandle == null ? other$debotHandle != null : !((Object)this$debotHandle).equals(other$debotHandle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfStart;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $debotHandle = this.debotHandle();
            result = result * 59 + ($debotHandle == null ? 43 : ((Object)$debotHandle).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfStart(debotHandle=" + this.debotHandle() + ")";
        }
    }

    public static final class ParamsOfFetch
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;

        @Generated
        public ParamsOfFetch(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfFetch)) {
                return false;
            }
            ParamsOfFetch other = (ParamsOfFetch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfFetch;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfFetch(address=" + this.address() + ")";
        }
    }

    public static final class ResultOfFetch
    extends JsonData {
        @SerializedName(value="info")
        @NonNull
        private final DebotInfo info;

        @Generated
        public ResultOfFetch(@NonNull DebotInfo info) {
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.info = info;
        }

        @NonNull
        @Generated
        public DebotInfo info() {
            return this.info;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfFetch)) {
                return false;
            }
            ResultOfFetch other = (ResultOfFetch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DebotInfo this$info = this.info();
            DebotInfo other$info = other.info();
            return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfFetch;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            DebotInfo $info = this.info();
            result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ResultOfFetch(info=" + this.info() + ")";
        }
    }

    public static final class ParamsOfExecute
    extends JsonData {
        @SerializedName(value="debot_handle")
        @NonNull
        private final Integer debotHandle;
        @SerializedName(value="action")
        @NonNull
        private final DebotAction action;

        @Generated
        public ParamsOfExecute(@NonNull Integer debotHandle, @NonNull DebotAction action) {
            if (debotHandle == null) {
                throw new NullPointerException("debotHandle is marked non-null but is null");
            }
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.debotHandle = debotHandle;
            this.action = action;
        }

        @NonNull
        @Generated
        public Integer debotHandle() {
            return this.debotHandle;
        }

        @NonNull
        @Generated
        public DebotAction action() {
            return this.action;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfExecute)) {
                return false;
            }
            ParamsOfExecute other = (ParamsOfExecute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$debotHandle = this.debotHandle();
            Integer other$debotHandle = other.debotHandle();
            if (this$debotHandle == null ? other$debotHandle != null : !((Object)this$debotHandle).equals(other$debotHandle)) {
                return false;
            }
            DebotAction this$action = this.action();
            DebotAction other$action = other.action();
            return !(this$action == null ? other$action != null : !((Object)this$action).equals(other$action));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfExecute;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $debotHandle = this.debotHandle();
            result = result * 59 + ($debotHandle == null ? 43 : ((Object)$debotHandle).hashCode());
            DebotAction $action = this.action();
            result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfExecute(debotHandle=" + this.debotHandle() + ", action=" + this.action() + ")";
        }
    }

    public static final class DebotAction
    extends JsonData {
        @SerializedName(value="description")
        @NonNull
        private final String description;
        @SerializedName(value="name")
        @NonNull
        private final String name;
        @SerializedName(value="action_type")
        @NonNull
        private final Number actionType;
        @SerializedName(value="to")
        @NonNull
        private final Number to;
        @SerializedName(value="attributes")
        @NonNull
        private final String attributes;
        @SerializedName(value="misc")
        @NonNull
        private final String misc;

        @Generated
        public DebotAction(@NonNull String description, @NonNull String name, @NonNull Number actionType, @NonNull Number to, @NonNull String attributes, @NonNull String misc) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (actionType == null) {
                throw new NullPointerException("actionType is marked non-null but is null");
            }
            if (to == null) {
                throw new NullPointerException("to is marked non-null but is null");
            }
            if (attributes == null) {
                throw new NullPointerException("attributes is marked non-null but is null");
            }
            if (misc == null) {
                throw new NullPointerException("misc is marked non-null but is null");
            }
            this.description = description;
            this.name = name;
            this.actionType = actionType;
            this.to = to;
            this.attributes = attributes;
            this.misc = misc;
        }

        @NonNull
        @Generated
        public String description() {
            return this.description;
        }

        @NonNull
        @Generated
        public String name() {
            return this.name;
        }

        @NonNull
        @Generated
        public Number actionType() {
            return this.actionType;
        }

        @NonNull
        @Generated
        public Number to() {
            return this.to;
        }

        @NonNull
        @Generated
        public String attributes() {
            return this.attributes;
        }

        @NonNull
        @Generated
        public String misc() {
            return this.misc;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebotAction)) {
                return false;
            }
            DebotAction other = (DebotAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$description = this.description();
            String other$description = other.description();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Number this$actionType = this.actionType();
            Number other$actionType = other.actionType();
            if (this$actionType == null ? other$actionType != null : !this$actionType.equals(other$actionType)) {
                return false;
            }
            Number this$to = this.to();
            Number other$to = other.to();
            if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
                return false;
            }
            String this$attributes = this.attributes();
            String other$attributes = other.attributes();
            if (this$attributes == null ? other$attributes != null : !this$attributes.equals(other$attributes)) {
                return false;
            }
            String this$misc = this.misc();
            String other$misc = other.misc();
            return !(this$misc == null ? other$misc != null : !this$misc.equals(other$misc));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DebotAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $description = this.description();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Number $actionType = this.actionType();
            result = result * 59 + ($actionType == null ? 43 : $actionType.hashCode());
            Number $to = this.to();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            String $attributes = this.attributes();
            result = result * 59 + ($attributes == null ? 43 : $attributes.hashCode());
            String $misc = this.misc();
            result = result * 59 + ($misc == null ? 43 : $misc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.DebotAction(description=" + this.description() + ", name=" + this.name() + ", actionType=" + this.actionType() + ", to=" + this.to() + ", attributes=" + this.attributes() + ", misc=" + this.misc() + ")";
        }
    }

    public static final class ParamsOfSend
    extends JsonData {
        @SerializedName(value="debot_handle")
        @NonNull
        private final Integer debotHandle;
        @SerializedName(value="message")
        @NonNull
        private final String message;

        @Generated
        public ParamsOfSend(@NonNull Integer debotHandle, @NonNull String message) {
            if (debotHandle == null) {
                throw new NullPointerException("debotHandle is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.debotHandle = debotHandle;
            this.message = message;
        }

        @NonNull
        @Generated
        public Integer debotHandle() {
            return this.debotHandle;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfSend)) {
                return false;
            }
            ParamsOfSend other = (ParamsOfSend)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$debotHandle = this.debotHandle();
            Integer other$debotHandle = other.debotHandle();
            if (this$debotHandle == null ? other$debotHandle != null : !((Object)this$debotHandle).equals(other$debotHandle)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfSend;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $debotHandle = this.debotHandle();
            result = result * 59 + ($debotHandle == null ? 43 : ((Object)$debotHandle).hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfSend(debotHandle=" + this.debotHandle() + ", message=" + this.message() + ")";
        }
    }

    public static final class ParamsOfRemove
    extends JsonData {
        @SerializedName(value="debot_handle")
        @NonNull
        private final Integer debotHandle;

        @Generated
        public ParamsOfRemove(@NonNull Integer debotHandle) {
            if (debotHandle == null) {
                throw new NullPointerException("debotHandle is marked non-null but is null");
            }
            this.debotHandle = debotHandle;
        }

        @NonNull
        @Generated
        public Integer debotHandle() {
            return this.debotHandle;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfRemove)) {
                return false;
            }
            ParamsOfRemove other = (ParamsOfRemove)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$debotHandle = this.debotHandle();
            Integer other$debotHandle = other.debotHandle();
            return !(this$debotHandle == null ? other$debotHandle != null : !((Object)this$debotHandle).equals(other$debotHandle));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfRemove;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $debotHandle = this.debotHandle();
            result = result * 59 + ($debotHandle == null ? 43 : ((Object)$debotHandle).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfRemove(debotHandle=" + this.debotHandle() + ")";
        }
    }

    public static abstract class ResultOfAppDebotBrowser {
        public static final InvokeDebot InvokeDebot = new InvokeDebot();

        public static final class InvokeDebot
        extends ResultOfAppDebotBrowser {
            @Generated
            public InvokeDebot() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvokeDebot)) {
                    return false;
                }
                InvokeDebot other = (InvokeDebot)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvokeDebot;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ResultOfAppDebotBrowser.InvokeDebot()";
            }
        }

        public static final class Approve
        extends ResultOfAppDebotBrowser {
            @SerializedName(value="approved")
            @NonNull
            private final Boolean approved;

            @Generated
            public Approve(@NonNull Boolean approved) {
                if (approved == null) {
                    throw new NullPointerException("approved is marked non-null but is null");
                }
                this.approved = approved;
            }

            @NonNull
            @Generated
            public Boolean approved() {
                return this.approved;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Approve)) {
                    return false;
                }
                Approve other = (Approve)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Boolean this$approved = this.approved();
                Boolean other$approved = other.approved();
                return !(this$approved == null ? other$approved != null : !((Object)this$approved).equals(other$approved));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Approve;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Boolean $approved = this.approved();
                result = result * 59 + ($approved == null ? 43 : ((Object)$approved).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ResultOfAppDebotBrowser.Approve(approved=" + this.approved() + ")";
            }
        }

        public static final class GetSigningBox
        extends ResultOfAppDebotBrowser {
            @SerializedName(value="signing_box")
            @NonNull
            private final Integer signingBox;

            @Generated
            public GetSigningBox(@NonNull Integer signingBox) {
                if (signingBox == null) {
                    throw new NullPointerException("signingBox is marked non-null but is null");
                }
                this.signingBox = signingBox;
            }

            @NonNull
            @Generated
            public Integer signingBox() {
                return this.signingBox;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetSigningBox)) {
                    return false;
                }
                GetSigningBox other = (GetSigningBox)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Integer this$signingBox = this.signingBox();
                Integer other$signingBox = other.signingBox();
                return !(this$signingBox == null ? other$signingBox != null : !((Object)this$signingBox).equals(other$signingBox));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetSigningBox;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Integer $signingBox = this.signingBox();
                result = result * 59 + ($signingBox == null ? 43 : ((Object)$signingBox).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ResultOfAppDebotBrowser.GetSigningBox(signingBox=" + this.signingBox() + ")";
            }
        }

        public static final class Input
        extends ResultOfAppDebotBrowser {
            @SerializedName(value="value")
            @NonNull
            private final String value;

            @Generated
            public Input(@NonNull String value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                this.value = value;
            }

            @NonNull
            @Generated
            public String value() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Input)) {
                    return false;
                }
                Input other = (Input)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$value = this.value();
                String other$value = other.value();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Input;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $value = this.value();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ResultOfAppDebotBrowser.Input(value=" + this.value() + ")";
            }
        }
    }

    public static abstract class ParamsOfAppDebotBrowser {
        public static final SwitchCompleted SwitchCompleted = new SwitchCompleted();
        public static final GetSigningBox GetSigningBox = new GetSigningBox();

        public static final class SwitchCompleted
        extends ParamsOfAppDebotBrowser {
            @Generated
            public SwitchCompleted() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SwitchCompleted)) {
                    return false;
                }
                SwitchCompleted other = (SwitchCompleted)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SwitchCompleted;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.SwitchCompleted()";
            }
        }

        public static final class GetSigningBox
        extends ParamsOfAppDebotBrowser {
            @Generated
            public GetSigningBox() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GetSigningBox)) {
                    return false;
                }
                GetSigningBox other = (GetSigningBox)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof GetSigningBox;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.GetSigningBox()";
            }
        }

        public static final class Approve
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="activity")
            @NonNull
            private final Map<String, Object> activity;

            @Generated
            public Approve(@NonNull Map<String, Object> activity) {
                if (activity == null) {
                    throw new NullPointerException("activity is marked non-null but is null");
                }
                this.activity = activity;
            }

            @NonNull
            @Generated
            public Map<String, Object> activity() {
                return this.activity;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Approve)) {
                    return false;
                }
                Approve other = (Approve)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Map<String, Object> this$activity = this.activity();
                Map<String, Object> other$activity = other.activity();
                return !(this$activity == null ? other$activity != null : !((Object)this$activity).equals(other$activity));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Approve;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Map<String, Object> $activity = this.activity();
                result = result * 59 + ($activity == null ? 43 : ((Object)$activity).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.Approve(activity=" + this.activity() + ")";
            }
        }

        public static final class Send
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="message")
            @NonNull
            private final String message;

            @Generated
            public Send(@NonNull String message) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
                this.message = message;
            }

            @NonNull
            @Generated
            public String message() {
                return this.message;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Send)) {
                    return false;
                }
                Send other = (Send)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$message = this.message();
                String other$message = other.message();
                return !(this$message == null ? other$message != null : !this$message.equals(other$message));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Send;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $message = this.message();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.Send(message=" + this.message() + ")";
            }
        }

        public static final class InvokeDebot
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="debot_addr")
            @NonNull
            private final String debotAddr;
            @SerializedName(value="action")
            @NonNull
            private final DebotAction action;

            @Generated
            public InvokeDebot(@NonNull String debotAddr, @NonNull DebotAction action) {
                if (debotAddr == null) {
                    throw new NullPointerException("debotAddr is marked non-null but is null");
                }
                if (action == null) {
                    throw new NullPointerException("action is marked non-null but is null");
                }
                this.debotAddr = debotAddr;
                this.action = action;
            }

            @NonNull
            @Generated
            public String debotAddr() {
                return this.debotAddr;
            }

            @NonNull
            @Generated
            public DebotAction action() {
                return this.action;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvokeDebot)) {
                    return false;
                }
                InvokeDebot other = (InvokeDebot)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$debotAddr = this.debotAddr();
                String other$debotAddr = other.debotAddr();
                if (this$debotAddr == null ? other$debotAddr != null : !this$debotAddr.equals(other$debotAddr)) {
                    return false;
                }
                DebotAction this$action = this.action();
                DebotAction other$action = other.action();
                return !(this$action == null ? other$action != null : !((Object)this$action).equals(other$action));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvokeDebot;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $debotAddr = this.debotAddr();
                result = result * 59 + ($debotAddr == null ? 43 : $debotAddr.hashCode());
                DebotAction $action = this.action();
                result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.InvokeDebot(debotAddr=" + this.debotAddr() + ", action=" + this.action() + ")";
            }
        }

        public static final class Input
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="prompt")
            @NonNull
            private final String prompt;

            @Generated
            public Input(@NonNull String prompt) {
                if (prompt == null) {
                    throw new NullPointerException("prompt is marked non-null but is null");
                }
                this.prompt = prompt;
            }

            @NonNull
            @Generated
            public String prompt() {
                return this.prompt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Input)) {
                    return false;
                }
                Input other = (Input)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$prompt = this.prompt();
                String other$prompt = other.prompt();
                return !(this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Input;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $prompt = this.prompt();
                result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.Input(prompt=" + this.prompt() + ")";
            }
        }

        public static final class ShowAction
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="action")
            @NonNull
            private final DebotAction action;

            @Generated
            public ShowAction(@NonNull DebotAction action) {
                if (action == null) {
                    throw new NullPointerException("action is marked non-null but is null");
                }
                this.action = action;
            }

            @NonNull
            @Generated
            public DebotAction action() {
                return this.action;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ShowAction)) {
                    return false;
                }
                ShowAction other = (ShowAction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                DebotAction this$action = this.action();
                DebotAction other$action = other.action();
                return !(this$action == null ? other$action != null : !((Object)this$action).equals(other$action));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof ShowAction;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                DebotAction $action = this.action();
                result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.ShowAction(action=" + this.action() + ")";
            }
        }

        public static final class Switch
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="context_id")
            @NonNull
            private final Number contextId;

            @Generated
            public Switch(@NonNull Number contextId) {
                if (contextId == null) {
                    throw new NullPointerException("contextId is marked non-null but is null");
                }
                this.contextId = contextId;
            }

            @NonNull
            @Generated
            public Number contextId() {
                return this.contextId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Switch)) {
                    return false;
                }
                Switch other = (Switch)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Number this$contextId = this.contextId();
                Number other$contextId = other.contextId();
                return !(this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Switch;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Number $contextId = this.contextId();
                result = result * 59 + ($contextId == null ? 43 : $contextId.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.Switch(contextId=" + this.contextId() + ")";
            }
        }

        public static final class Log
        extends ParamsOfAppDebotBrowser {
            @SerializedName(value="msg")
            @NonNull
            private final String msg;

            @Generated
            public Log(@NonNull String msg) {
                if (msg == null) {
                    throw new NullPointerException("msg is marked non-null but is null");
                }
                this.msg = msg;
            }

            @NonNull
            @Generated
            public String msg() {
                return this.msg;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Log)) {
                    return false;
                }
                Log other = (Log)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$msg = this.msg();
                String other$msg = other.msg();
                return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Log;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $msg = this.msg();
                result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Debot.ParamsOfAppDebotBrowser.Log(msg=" + this.msg() + ")";
            }
        }
    }

    public static final class RegisteredDebot
    extends JsonData {
        @SerializedName(value="debot_handle")
        @NonNull
        private final Integer debotHandle;
        @SerializedName(value="debot_abi")
        @NonNull
        private final String debotAbi;
        @SerializedName(value="info")
        @NonNull
        private final DebotInfo info;

        @Generated
        public RegisteredDebot(@NonNull Integer debotHandle, @NonNull String debotAbi, @NonNull DebotInfo info) {
            if (debotHandle == null) {
                throw new NullPointerException("debotHandle is marked non-null but is null");
            }
            if (debotAbi == null) {
                throw new NullPointerException("debotAbi is marked non-null but is null");
            }
            if (info == null) {
                throw new NullPointerException("info is marked non-null but is null");
            }
            this.debotHandle = debotHandle;
            this.debotAbi = debotAbi;
            this.info = info;
        }

        @NonNull
        @Generated
        public Integer debotHandle() {
            return this.debotHandle;
        }

        @NonNull
        @Generated
        public String debotAbi() {
            return this.debotAbi;
        }

        @NonNull
        @Generated
        public DebotInfo info() {
            return this.info;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegisteredDebot)) {
                return false;
            }
            RegisteredDebot other = (RegisteredDebot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$debotHandle = this.debotHandle();
            Integer other$debotHandle = other.debotHandle();
            if (this$debotHandle == null ? other$debotHandle != null : !((Object)this$debotHandle).equals(other$debotHandle)) {
                return false;
            }
            String this$debotAbi = this.debotAbi();
            String other$debotAbi = other.debotAbi();
            if (this$debotAbi == null ? other$debotAbi != null : !this$debotAbi.equals(other$debotAbi)) {
                return false;
            }
            DebotInfo this$info = this.info();
            DebotInfo other$info = other.info();
            return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RegisteredDebot;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $debotHandle = this.debotHandle();
            result = result * 59 + ($debotHandle == null ? 43 : ((Object)$debotHandle).hashCode());
            String $debotAbi = this.debotAbi();
            result = result * 59 + ($debotAbi == null ? 43 : $debotAbi.hashCode());
            DebotInfo $info = this.info();
            result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.RegisteredDebot(debotHandle=" + this.debotHandle() + ", debotAbi=" + this.debotAbi() + ", info=" + this.info() + ")";
        }
    }

    public static final class ParamsOfInit
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;

        @Generated
        public ParamsOfInit(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfInit)) {
                return false;
            }
            ParamsOfInit other = (ParamsOfInit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfInit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.ParamsOfInit(address=" + this.address() + ")";
        }
    }

    public static final class DebotInfo
    extends JsonData {
        @SerializedName(value="name")
        private final String name;
        @SerializedName(value="version")
        private final String version;
        @SerializedName(value="publisher")
        private final String publisher;
        @SerializedName(value="caption")
        private final String caption;
        @SerializedName(value="author")
        private final String author;
        @SerializedName(value="support")
        private final String support;
        @SerializedName(value="hello")
        private final String hello;
        @SerializedName(value="language")
        private final String language;
        @SerializedName(value="dabi")
        private final String dabi;
        @SerializedName(value="icon")
        private final String icon;
        @SerializedName(value="interfaces")
        @NonNull
        private final String[] interfaces;
        @SerializedName(value="dabiVersion")
        @NonNull
        private final String dabiVersion;

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> version() {
            return Optional.ofNullable(this.version);
        }

        public Optional<String> publisher() {
            return Optional.ofNullable(this.publisher);
        }

        public Optional<String> caption() {
            return Optional.ofNullable(this.caption);
        }

        public Optional<String> author() {
            return Optional.ofNullable(this.author);
        }

        public Optional<String> support() {
            return Optional.ofNullable(this.support);
        }

        public Optional<String> hello() {
            return Optional.ofNullable(this.hello);
        }

        public Optional<String> language() {
            return Optional.ofNullable(this.language);
        }

        public Optional<String> dabi() {
            return Optional.ofNullable(this.dabi);
        }

        public Optional<String> icon() {
            return Optional.ofNullable(this.icon);
        }

        @Generated
        public DebotInfo(String name, String version, String publisher, String caption, String author, String support, String hello, String language, String dabi, String icon, @NonNull String[] interfaces, @NonNull String dabiVersion) {
            if (interfaces == null) {
                throw new NullPointerException("interfaces is marked non-null but is null");
            }
            if (dabiVersion == null) {
                throw new NullPointerException("dabiVersion is marked non-null but is null");
            }
            this.name = name;
            this.version = version;
            this.publisher = publisher;
            this.caption = caption;
            this.author = author;
            this.support = support;
            this.hello = hello;
            this.language = language;
            this.dabi = dabi;
            this.icon = icon;
            this.interfaces = interfaces;
            this.dabiVersion = dabiVersion;
        }

        @NonNull
        @Generated
        public String[] interfaces() {
            return this.interfaces;
        }

        @NonNull
        @Generated
        public String dabiVersion() {
            return this.dabiVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DebotInfo)) {
                return false;
            }
            DebotInfo other = (DebotInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<String> this$name = this.name();
            Optional<String> other$name = other.name();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            Optional<String> this$version = this.version();
            Optional<String> other$version = other.version();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            Optional<String> this$publisher = this.publisher();
            Optional<String> other$publisher = other.publisher();
            if (this$publisher == null ? other$publisher != null : !((Object)this$publisher).equals(other$publisher)) {
                return false;
            }
            Optional<String> this$caption = this.caption();
            Optional<String> other$caption = other.caption();
            if (this$caption == null ? other$caption != null : !((Object)this$caption).equals(other$caption)) {
                return false;
            }
            Optional<String> this$author = this.author();
            Optional<String> other$author = other.author();
            if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
                return false;
            }
            Optional<String> this$support = this.support();
            Optional<String> other$support = other.support();
            if (this$support == null ? other$support != null : !((Object)this$support).equals(other$support)) {
                return false;
            }
            Optional<String> this$hello = this.hello();
            Optional<String> other$hello = other.hello();
            if (this$hello == null ? other$hello != null : !((Object)this$hello).equals(other$hello)) {
                return false;
            }
            Optional<String> this$language = this.language();
            Optional<String> other$language = other.language();
            if (this$language == null ? other$language != null : !((Object)this$language).equals(other$language)) {
                return false;
            }
            Optional<String> this$dabi = this.dabi();
            Optional<String> other$dabi = other.dabi();
            if (this$dabi == null ? other$dabi != null : !((Object)this$dabi).equals(other$dabi)) {
                return false;
            }
            Optional<String> this$icon = this.icon();
            Optional<String> other$icon = other.icon();
            if (this$icon == null ? other$icon != null : !((Object)this$icon).equals(other$icon)) {
                return false;
            }
            if (!Arrays.deepEquals(this.interfaces(), other.interfaces())) {
                return false;
            }
            String this$dabiVersion = this.dabiVersion();
            String other$dabiVersion = other.dabiVersion();
            return !(this$dabiVersion == null ? other$dabiVersion != null : !this$dabiVersion.equals(other$dabiVersion));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DebotInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<String> $name = this.name();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            Optional<String> $version = this.version();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            Optional<String> $publisher = this.publisher();
            result = result * 59 + ($publisher == null ? 43 : ((Object)$publisher).hashCode());
            Optional<String> $caption = this.caption();
            result = result * 59 + ($caption == null ? 43 : ((Object)$caption).hashCode());
            Optional<String> $author = this.author();
            result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
            Optional<String> $support = this.support();
            result = result * 59 + ($support == null ? 43 : ((Object)$support).hashCode());
            Optional<String> $hello = this.hello();
            result = result * 59 + ($hello == null ? 43 : ((Object)$hello).hashCode());
            Optional<String> $language = this.language();
            result = result * 59 + ($language == null ? 43 : ((Object)$language).hashCode());
            Optional<String> $dabi = this.dabi();
            result = result * 59 + ($dabi == null ? 43 : ((Object)$dabi).hashCode());
            Optional<String> $icon = this.icon();
            result = result * 59 + ($icon == null ? 43 : ((Object)$icon).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.interfaces());
            String $dabiVersion = this.dabiVersion();
            result = result * 59 + ($dabiVersion == null ? 43 : $dabiVersion.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Debot.DebotInfo(name=" + this.name() + ", version=" + this.version() + ", publisher=" + this.publisher() + ", caption=" + this.caption() + ", author=" + this.author() + ", support=" + this.support() + ", hello=" + this.hello() + ", language=" + this.language() + ", dabi=" + this.dabi() + ", icon=" + this.icon() + ", interfaces=" + Arrays.deepToString(this.interfaces()) + ", dabiVersion=" + this.dabiVersion() + ")";
        }
    }
}

