/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.json.JsonData;

public class Abi {
    public static CompletableFuture<ResultOfEncodeMessageBody> encodeMessageBody(@NonNull Context context, @NonNull ABI abi, @NonNull CallSet callSet, @NonNull Boolean isInternal, @NonNull Signer signer, Number processingTryIndex) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (callSet == null) {
            throw new NullPointerException("callSet is marked non-null but is null");
        }
        if (isInternal == null) {
            throw new NullPointerException("isInternal is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        return context.future("abi.encode_message_body", new ParamsOfEncodeMessageBody(abi, callSet, isInternal, signer, processingTryIndex), ResultOfEncodeMessageBody.class);
    }

    public static CompletableFuture<ResultOfAttachSignatureToMessageBody> attachSignatureToMessageBody(@NonNull Context context, @NonNull ABI abi, @NonNull String publicKey, @NonNull String message, @NonNull String signature) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return context.future("abi.attach_signature_to_message_body", new ParamsOfAttachSignatureToMessageBody(abi, publicKey, message, signature), ResultOfAttachSignatureToMessageBody.class);
    }

    public static CompletableFuture<ResultOfEncodeMessage> encodeMessage(@NonNull Context context, @NonNull ABI abi, String address, DeploySet deploySet, CallSet callSet, @NonNull Signer signer, Number processingTryIndex) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        return context.future("abi.encode_message", new ParamsOfEncodeMessage(abi, address, deploySet, callSet, signer, processingTryIndex), ResultOfEncodeMessage.class);
    }

    public static CompletableFuture<ResultOfEncodeInternalMessage> encodeInternalMessage(@NonNull Context context, ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, @NonNull String value, Boolean bounce, Boolean enableIhr) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return context.future("abi.encode_internal_message", new ParamsOfEncodeInternalMessage(abi, address, srcAddress, deploySet, callSet, value, bounce, enableIhr), ResultOfEncodeInternalMessage.class);
    }

    public static CompletableFuture<ResultOfAttachSignature> attachSignature(@NonNull Context context, @NonNull ABI abi, @NonNull String publicKey, @NonNull String message, @NonNull String signature) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (signature == null) {
            throw new NullPointerException("signature is marked non-null but is null");
        }
        return context.future("abi.attach_signature", new ParamsOfAttachSignature(abi, publicKey, message, signature), ResultOfAttachSignature.class);
    }

    public static CompletableFuture<DecodedMessageBody> decodeMessage(@NonNull Context context, @NonNull ABI abi, @NonNull String message) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return context.future("abi.decode_message", new ParamsOfDecodeMessage(abi, message), DecodedMessageBody.class);
    }

    public static CompletableFuture<DecodedMessageBody> decodeMessageBody(@NonNull Context context, @NonNull ABI abi, @NonNull String body, @NonNull Boolean isInternal) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (isInternal == null) {
            throw new NullPointerException("isInternal is marked non-null but is null");
        }
        return context.future("abi.decode_message_body", new ParamsOfDecodeMessageBody(abi, body, isInternal), DecodedMessageBody.class);
    }

    public static CompletableFuture<ResultOfEncodeAccount> encodeAccount(@NonNull Context context, @NonNull StateInitSource stateInit, Long balance, Long lastTransLt, Number lastPaid, Boc.BocCacheType bocCache) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (stateInit == null) {
            throw new NullPointerException("stateInit is marked non-null but is null");
        }
        return context.future("abi.encode_account", new ParamsOfEncodeAccount(stateInit, balance, lastTransLt, lastPaid, bocCache), ResultOfEncodeAccount.class);
    }

    public static CompletableFuture<ResultOfDecodeAccountData> decodeAccountData(@NonNull Context context, @NonNull ABI abi, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (abi == null) {
            throw new NullPointerException("abi is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("abi.decode_account_data", new ParamsOfDecodeAccountData(abi, data), ResultOfDecodeAccountData.class);
    }

    public static CompletableFuture<ResultOfUpdateInitialData> updateInitialData(@NonNull Context context, ABI abi, @NonNull String data, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("abi.update_initial_data", new ParamsOfUpdateInitialData(abi, data, initialData, initialPubkey, bocCache), ResultOfUpdateInitialData.class);
    }

    public static CompletableFuture<ResultOfEncodeInitialData> encodeInitialData(@NonNull Context context, ABI abi, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        return context.future("abi.encode_initial_data", new ParamsOfEncodeInitialData(abi, initialData, initialPubkey, bocCache), ResultOfEncodeInitialData.class);
    }

    public static CompletableFuture<ResultOfDecodeInitialData> decodeInitialData(@NonNull Context context, ABI abi, @NonNull String data) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return context.future("abi.decode_initial_data", new ParamsOfDecodeInitialData(abi, data), ResultOfDecodeInitialData.class);
    }

    public static CompletableFuture<ResultOfDecodeBoc> decodeBoc(@NonNull Context context, @NonNull AbiParam[] params, @NonNull String boc, @NonNull Boolean allowPartial) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (boc == null) {
            throw new NullPointerException("boc is marked non-null but is null");
        }
        if (allowPartial == null) {
            throw new NullPointerException("allowPartial is marked non-null but is null");
        }
        return context.future("abi.decode_boc", new ParamsOfDecodeBoc(params, boc, allowPartial), ResultOfDecodeBoc.class);
    }

    public static final class ParamsOfEncodeMessageBody
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="call_set")
        @NonNull
        private final CallSet callSet;
        @SerializedName(value="is_internal")
        @NonNull
        private final Boolean isInternal;
        @SerializedName(value="signer")
        @NonNull
        private final Signer signer;
        @SerializedName(value="processing_try_index")
        private final Number processingTryIndex;

        public Optional<Number> processingTryIndex() {
            return Optional.ofNullable(this.processingTryIndex);
        }

        @Generated
        public ParamsOfEncodeMessageBody(@NonNull ABI abi, @NonNull CallSet callSet, @NonNull Boolean isInternal, @NonNull Signer signer, Number processingTryIndex) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (callSet == null) {
                throw new NullPointerException("callSet is marked non-null but is null");
            }
            if (isInternal == null) {
                throw new NullPointerException("isInternal is marked non-null but is null");
            }
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            this.abi = abi;
            this.callSet = callSet;
            this.isInternal = isInternal;
            this.signer = signer;
            this.processingTryIndex = processingTryIndex;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public CallSet callSet() {
            return this.callSet;
        }

        @NonNull
        @Generated
        public Boolean isInternal() {
            return this.isInternal;
        }

        @NonNull
        @Generated
        public Signer signer() {
            return this.signer;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncodeMessageBody)) {
                return false;
            }
            ParamsOfEncodeMessageBody other = (ParamsOfEncodeMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$isInternal = this.isInternal();
            Boolean other$isInternal = other.isInternal();
            if (this$isInternal == null ? other$isInternal != null : !((Object)this$isInternal).equals(other$isInternal)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            CallSet this$callSet = this.callSet();
            CallSet other$callSet = other.callSet();
            if (this$callSet == null ? other$callSet != null : !((Object)this$callSet).equals(other$callSet)) {
                return false;
            }
            Signer this$signer = this.signer();
            Signer other$signer = other.signer();
            if (this$signer == null ? other$signer != null : !this$signer.equals(other$signer)) {
                return false;
            }
            Optional<Number> this$processingTryIndex = this.processingTryIndex();
            Optional<Number> other$processingTryIndex = other.processingTryIndex();
            return !(this$processingTryIndex == null ? other$processingTryIndex != null : !((Object)this$processingTryIndex).equals(other$processingTryIndex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncodeMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $isInternal = this.isInternal();
            result = result * 59 + ($isInternal == null ? 43 : ((Object)$isInternal).hashCode());
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            CallSet $callSet = this.callSet();
            result = result * 59 + ($callSet == null ? 43 : ((Object)$callSet).hashCode());
            Signer $signer = this.signer();
            result = result * 59 + ($signer == null ? 43 : $signer.hashCode());
            Optional<Number> $processingTryIndex = this.processingTryIndex();
            result = result * 59 + ($processingTryIndex == null ? 43 : ((Object)$processingTryIndex).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfEncodeMessageBody(abi=" + this.abi() + ", callSet=" + this.callSet() + ", isInternal=" + this.isInternal() + ", signer=" + this.signer() + ", processingTryIndex=" + this.processingTryIndex() + ")";
        }
    }

    public static abstract class ABI {

        public static final class Serialized
        extends ABI {
            @SerializedName(value="type")
            @NonNull
            private final String type = "Serialized";
            @SerializedName(value="value")
            @NonNull
            private final Map<String, Object> value;

            @Generated
            public Serialized(@NonNull Map<String, Object> value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                this.value = value;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public Map<String, Object> value() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Serialized)) {
                    return false;
                }
                Serialized other = (Serialized)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                Map<String, Object> this$value = this.value();
                Map<String, Object> other$value = other.value();
                return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Serialized;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                Map<String, Object> $value = this.value();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.ABI.Serialized(type=" + this.type() + ", value=" + this.value() + ")";
            }
        }

        public static final class Handle
        extends ABI {
            @SerializedName(value="type")
            @NonNull
            private final String type = "Handle";
            @SerializedName(value="value")
            @NonNull
            private final Integer value;

            @Generated
            public Handle(@NonNull Integer value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                this.value = value;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public Integer value() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Handle)) {
                    return false;
                }
                Handle other = (Handle)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Integer this$value = this.value();
                Integer other$value = other.value();
                if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Handle;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Integer $value = this.value();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.ABI.Handle(type=" + this.type() + ", value=" + this.value() + ")";
            }
        }

        public static final class Json
        extends ABI {
            @SerializedName(value="type")
            @NonNull
            private final String type = "Json";
            @SerializedName(value="value")
            @NonNull
            private final String value;

            @Generated
            public Json(@NonNull String value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                this.value = value;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public String value() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Json)) {
                    return false;
                }
                Json other = (Json)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$value = this.value();
                String other$value = other.value();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Json;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $value = this.value();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.ABI.Json(type=" + this.type() + ", value=" + this.value() + ")";
            }
        }

        public static final class Contract
        extends ABI {
            @SerializedName(value="type")
            @NonNull
            private final String type = "Contract";
            @SerializedName(value="value")
            @NonNull
            private final Object value;

            @Generated
            public Contract(@NonNull Object value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                this.value = value;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public Object value() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Contract)) {
                    return false;
                }
                Contract other = (Contract)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                Object this$value = this.value();
                Object other$value = other.value();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Contract;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                Object $value = this.value();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.ABI.Contract(type=" + this.type() + ", value=" + this.value() + ")";
            }
        }
    }

    public static final class CallSet
    extends JsonData {
        @SerializedName(value="function_name")
        @NonNull
        private final String functionName;
        @SerializedName(value="header")
        private final FunctionHeader header;
        @SerializedName(value="input")
        private final Map<String, Object> input;

        public Optional<FunctionHeader> header() {
            return Optional.ofNullable(this.header);
        }

        public Optional<Map<String, Object>> input() {
            return Optional.ofNullable(this.input);
        }

        @Generated
        public CallSet(@NonNull String functionName, FunctionHeader header, Map<String, Object> input) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName = functionName;
            this.header = header;
            this.input = input;
        }

        @NonNull
        @Generated
        public String functionName() {
            return this.functionName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallSet)) {
                return false;
            }
            CallSet other = (CallSet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$functionName = this.functionName();
            String other$functionName = other.functionName();
            if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
                return false;
            }
            Optional<FunctionHeader> this$header = this.header();
            Optional<FunctionHeader> other$header = other.header();
            if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
                return false;
            }
            Optional<Map<String, Object>> this$input = this.input();
            Optional<Map<String, Object>> other$input = other.input();
            return !(this$input == null ? other$input != null : !((Object)this$input).equals(other$input));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CallSet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $functionName = this.functionName();
            result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
            Optional<FunctionHeader> $header = this.header();
            result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
            Optional<Map<String, Object>> $input = this.input();
            result = result * 59 + ($input == null ? 43 : ((Object)$input).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.CallSet(functionName=" + this.functionName() + ", header=" + this.header() + ", input=" + this.input() + ")";
        }
    }

    public static abstract class Signer {
        public static final None None = new None();

        public static final class None
        extends Signer {
            @SerializedName(value="type")
            @NonNull
            private final String type = "None";

            @Generated
            public None() {
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof None)) {
                    return false;
                }
                None other = (None)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof None;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.Signer.None(type=" + this.type() + ")";
            }
        }

        public static final class SigningBox
        extends Signer {
            @SerializedName(value="type")
            @NonNull
            private final String type = "SigningBox";
            @SerializedName(value="handle")
            @NonNull
            private final Integer handle;

            @Generated
            public SigningBox(@NonNull Integer handle) {
                if (handle == null) {
                    throw new NullPointerException("handle is marked non-null but is null");
                }
                this.handle = handle;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public Integer handle() {
                return this.handle;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SigningBox)) {
                    return false;
                }
                SigningBox other = (SigningBox)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Integer this$handle = this.handle();
                Integer other$handle = other.handle();
                if (this$handle == null ? other$handle != null : !((Object)this$handle).equals(other$handle)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SigningBox;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Integer $handle = this.handle();
                result = result * 59 + ($handle == null ? 43 : ((Object)$handle).hashCode());
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.Signer.SigningBox(type=" + this.type() + ", handle=" + this.handle() + ")";
            }
        }

        public static final class Keys
        extends Signer {
            @SerializedName(value="type")
            @NonNull
            private final String type = "Keys";
            @SerializedName(value="keys")
            @NonNull
            private final Crypto.KeyPair keys;

            @Generated
            public Keys(@NonNull Crypto.KeyPair keys) {
                if (keys == null) {
                    throw new NullPointerException("keys is marked non-null but is null");
                }
                this.keys = keys;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public Crypto.KeyPair keys() {
                return this.keys;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Keys)) {
                    return false;
                }
                Keys other = (Keys)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                Crypto.KeyPair this$keys = this.keys();
                Crypto.KeyPair other$keys = other.keys();
                return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Keys;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                Crypto.KeyPair $keys = this.keys();
                result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.Signer.Keys(type=" + this.type() + ", keys=" + this.keys() + ")";
            }
        }

        public static final class External
        extends Signer {
            @SerializedName(value="type")
            @NonNull
            private final String type = "External";
            @SerializedName(value="public_key")
            @NonNull
            private final String publicKey;

            @Generated
            public External(@NonNull String publicKey) {
                if (publicKey == null) {
                    throw new NullPointerException("publicKey is marked non-null but is null");
                }
                this.publicKey = publicKey;
            }

            @NonNull
            @Generated
            public String type() {
                return this.type;
            }

            @NonNull
            @Generated
            public String publicKey() {
                return this.publicKey;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof External)) {
                    return false;
                }
                External other = (External)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$type = this.type();
                String other$type = other.type();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                String this$publicKey = this.publicKey();
                String other$publicKey = other.publicKey();
                return !(this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof External;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $type = this.type();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                String $publicKey = this.publicKey();
                result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.Signer.External(type=" + this.type() + ", publicKey=" + this.publicKey() + ")";
            }
        }
    }

    public static final class ResultOfEncodeMessageBody
    extends JsonData {
        @SerializedName(value="body")
        @NonNull
        private final String body;
        @SerializedName(value="data_to_sign")
        private final String dataToSign;

        public Optional<String> dataToSign() {
            return Optional.ofNullable(this.dataToSign);
        }

        @Generated
        public ResultOfEncodeMessageBody(@NonNull String body, String dataToSign) {
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            this.body = body;
            this.dataToSign = dataToSign;
        }

        @NonNull
        @Generated
        public String body() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncodeMessageBody)) {
                return false;
            }
            ResultOfEncodeMessageBody other = (ResultOfEncodeMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$body = this.body();
            String other$body = other.body();
            if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
                return false;
            }
            Optional<String> this$dataToSign = this.dataToSign();
            Optional<String> other$dataToSign = other.dataToSign();
            return !(this$dataToSign == null ? other$dataToSign != null : !((Object)this$dataToSign).equals(other$dataToSign));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncodeMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $body = this.body();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            Optional<String> $dataToSign = this.dataToSign();
            result = result * 59 + ($dataToSign == null ? 43 : ((Object)$dataToSign).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfEncodeMessageBody(body=" + this.body() + ", dataToSign=" + this.dataToSign() + ")";
        }
    }

    public static final class ParamsOfAttachSignatureToMessageBody
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="public_key")
        @NonNull
        private final String publicKey;
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="signature")
        @NonNull
        private final String signature;

        @Generated
        public ParamsOfAttachSignatureToMessageBody(@NonNull ABI abi, @NonNull String publicKey, @NonNull String message, @NonNull String signature) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.abi = abi;
            this.publicKey = publicKey;
            this.message = message;
            this.signature = signature;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfAttachSignatureToMessageBody)) {
                return false;
            }
            ParamsOfAttachSignatureToMessageBody other = (ParamsOfAttachSignatureToMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfAttachSignatureToMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfAttachSignatureToMessageBody(abi=" + this.abi() + ", publicKey=" + this.publicKey() + ", message=" + this.message() + ", signature=" + this.signature() + ")";
        }
    }

    public static final class ResultOfAttachSignatureToMessageBody
    extends JsonData {
        @SerializedName(value="body")
        @NonNull
        private final String body;

        @Generated
        public ResultOfAttachSignatureToMessageBody(@NonNull String body) {
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            this.body = body;
        }

        @NonNull
        @Generated
        public String body() {
            return this.body;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfAttachSignatureToMessageBody)) {
                return false;
            }
            ResultOfAttachSignatureToMessageBody other = (ResultOfAttachSignatureToMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$body = this.body();
            String other$body = other.body();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfAttachSignatureToMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $body = this.body();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfAttachSignatureToMessageBody(body=" + this.body() + ")";
        }
    }

    public static final class ParamsOfEncodeMessage
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="address")
        private final String address;
        @SerializedName(value="deploy_set")
        private final DeploySet deploySet;
        @SerializedName(value="call_set")
        private final CallSet callSet;
        @SerializedName(value="signer")
        @NonNull
        private final Signer signer;
        @SerializedName(value="processing_try_index")
        private final Number processingTryIndex;

        public Optional<String> address() {
            return Optional.ofNullable(this.address);
        }

        public Optional<DeploySet> deploySet() {
            return Optional.ofNullable(this.deploySet);
        }

        public Optional<CallSet> callSet() {
            return Optional.ofNullable(this.callSet);
        }

        public Optional<Number> processingTryIndex() {
            return Optional.ofNullable(this.processingTryIndex);
        }

        @Generated
        public ParamsOfEncodeMessage(@NonNull ABI abi, String address, DeploySet deploySet, CallSet callSet, @NonNull Signer signer, Number processingTryIndex) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            this.abi = abi;
            this.address = address;
            this.deploySet = deploySet;
            this.callSet = callSet;
            this.signer = signer;
            this.processingTryIndex = processingTryIndex;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public Signer signer() {
            return this.signer;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncodeMessage)) {
                return false;
            }
            ParamsOfEncodeMessage other = (ParamsOfEncodeMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            Optional<String> this$address = this.address();
            Optional<String> other$address = other.address();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Optional<DeploySet> this$deploySet = this.deploySet();
            Optional<DeploySet> other$deploySet = other.deploySet();
            if (this$deploySet == null ? other$deploySet != null : !((Object)this$deploySet).equals(other$deploySet)) {
                return false;
            }
            Optional<CallSet> this$callSet = this.callSet();
            Optional<CallSet> other$callSet = other.callSet();
            if (this$callSet == null ? other$callSet != null : !((Object)this$callSet).equals(other$callSet)) {
                return false;
            }
            Signer this$signer = this.signer();
            Signer other$signer = other.signer();
            if (this$signer == null ? other$signer != null : !this$signer.equals(other$signer)) {
                return false;
            }
            Optional<Number> this$processingTryIndex = this.processingTryIndex();
            Optional<Number> other$processingTryIndex = other.processingTryIndex();
            return !(this$processingTryIndex == null ? other$processingTryIndex != null : !((Object)this$processingTryIndex).equals(other$processingTryIndex));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncodeMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            Optional<String> $address = this.address();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Optional<DeploySet> $deploySet = this.deploySet();
            result = result * 59 + ($deploySet == null ? 43 : ((Object)$deploySet).hashCode());
            Optional<CallSet> $callSet = this.callSet();
            result = result * 59 + ($callSet == null ? 43 : ((Object)$callSet).hashCode());
            Signer $signer = this.signer();
            result = result * 59 + ($signer == null ? 43 : $signer.hashCode());
            Optional<Number> $processingTryIndex = this.processingTryIndex();
            result = result * 59 + ($processingTryIndex == null ? 43 : ((Object)$processingTryIndex).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfEncodeMessage(abi=" + this.abi() + ", address=" + this.address() + ", deploySet=" + this.deploySet() + ", callSet=" + this.callSet() + ", signer=" + this.signer() + ", processingTryIndex=" + this.processingTryIndex() + ")";
        }
    }

    public static final class DeploySet
    extends JsonData {
        @SerializedName(value="tvc")
        @NonNull
        private final String tvc;
        @SerializedName(value="workchain_id")
        private final Number workchainId;
        @SerializedName(value="initial_data")
        private final Map<String, Object> initialData;
        @SerializedName(value="initial_pubkey")
        private final String initialPubkey;

        public Optional<Number> workchainId() {
            return Optional.ofNullable(this.workchainId);
        }

        public Optional<Map<String, Object>> initialData() {
            return Optional.ofNullable(this.initialData);
        }

        public Optional<String> initialPubkey() {
            return Optional.ofNullable(this.initialPubkey);
        }

        @Generated
        public DeploySet(@NonNull String tvc, Number workchainId, Map<String, Object> initialData, String initialPubkey) {
            if (tvc == null) {
                throw new NullPointerException("tvc is marked non-null but is null");
            }
            this.tvc = tvc;
            this.workchainId = workchainId;
            this.initialData = initialData;
            this.initialPubkey = initialPubkey;
        }

        @NonNull
        @Generated
        public String tvc() {
            return this.tvc;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeploySet)) {
                return false;
            }
            DeploySet other = (DeploySet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$tvc = this.tvc();
            String other$tvc = other.tvc();
            if (this$tvc == null ? other$tvc != null : !this$tvc.equals(other$tvc)) {
                return false;
            }
            Optional<Number> this$workchainId = this.workchainId();
            Optional<Number> other$workchainId = other.workchainId();
            if (this$workchainId == null ? other$workchainId != null : !((Object)this$workchainId).equals(other$workchainId)) {
                return false;
            }
            Optional<Map<String, Object>> this$initialData = this.initialData();
            Optional<Map<String, Object>> other$initialData = other.initialData();
            if (this$initialData == null ? other$initialData != null : !((Object)this$initialData).equals(other$initialData)) {
                return false;
            }
            Optional<String> this$initialPubkey = this.initialPubkey();
            Optional<String> other$initialPubkey = other.initialPubkey();
            return !(this$initialPubkey == null ? other$initialPubkey != null : !((Object)this$initialPubkey).equals(other$initialPubkey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DeploySet;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $tvc = this.tvc();
            result = result * 59 + ($tvc == null ? 43 : $tvc.hashCode());
            Optional<Number> $workchainId = this.workchainId();
            result = result * 59 + ($workchainId == null ? 43 : ((Object)$workchainId).hashCode());
            Optional<Map<String, Object>> $initialData = this.initialData();
            result = result * 59 + ($initialData == null ? 43 : ((Object)$initialData).hashCode());
            Optional<String> $initialPubkey = this.initialPubkey();
            result = result * 59 + ($initialPubkey == null ? 43 : ((Object)$initialPubkey).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.DeploySet(tvc=" + this.tvc() + ", workchainId=" + this.workchainId() + ", initialData=" + this.initialData() + ", initialPubkey=" + this.initialPubkey() + ")";
        }
    }

    public static final class ResultOfEncodeMessage
    extends JsonData {
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="data_to_sign")
        private final String dataToSign;
        @SerializedName(value="address")
        @NonNull
        private final String address;
        @SerializedName(value="message_id")
        @NonNull
        private final String messageId;

        public Optional<String> dataToSign() {
            return Optional.ofNullable(this.dataToSign);
        }

        @Generated
        public ResultOfEncodeMessage(@NonNull String message, String dataToSign, @NonNull String address, @NonNull String messageId) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.message = message;
            this.dataToSign = dataToSign;
            this.address = address;
            this.messageId = messageId;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @NonNull
        @Generated
        public String messageId() {
            return this.messageId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncodeMessage)) {
                return false;
            }
            ResultOfEncodeMessage other = (ResultOfEncodeMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Optional<String> this$dataToSign = this.dataToSign();
            Optional<String> other$dataToSign = other.dataToSign();
            if (this$dataToSign == null ? other$dataToSign != null : !((Object)this$dataToSign).equals(other$dataToSign)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$messageId = this.messageId();
            String other$messageId = other.messageId();
            return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncodeMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Optional<String> $dataToSign = this.dataToSign();
            result = result * 59 + ($dataToSign == null ? 43 : ((Object)$dataToSign).hashCode());
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $messageId = this.messageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfEncodeMessage(message=" + this.message() + ", dataToSign=" + this.dataToSign() + ", address=" + this.address() + ", messageId=" + this.messageId() + ")";
        }
    }

    public static final class ParamsOfEncodeInternalMessage
    extends JsonData {
        @SerializedName(value="abi")
        private final ABI abi;
        @SerializedName(value="address")
        private final String address;
        @SerializedName(value="src_address")
        private final String srcAddress;
        @SerializedName(value="deploy_set")
        private final DeploySet deploySet;
        @SerializedName(value="call_set")
        private final CallSet callSet;
        @SerializedName(value="value")
        @NonNull
        private final String value;
        @SerializedName(value="bounce")
        private final Boolean bounce;
        @SerializedName(value="enable_ihr")
        private final Boolean enableIhr;

        public Optional<ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        public Optional<String> address() {
            return Optional.ofNullable(this.address);
        }

        public Optional<String> srcAddress() {
            return Optional.ofNullable(this.srcAddress);
        }

        public Optional<DeploySet> deploySet() {
            return Optional.ofNullable(this.deploySet);
        }

        public Optional<CallSet> callSet() {
            return Optional.ofNullable(this.callSet);
        }

        public Optional<Boolean> bounce() {
            return Optional.ofNullable(this.bounce);
        }

        public Optional<Boolean> enableIhr() {
            return Optional.ofNullable(this.enableIhr);
        }

        @Generated
        public ParamsOfEncodeInternalMessage(ABI abi, String address, String srcAddress, DeploySet deploySet, CallSet callSet, @NonNull String value, Boolean bounce, Boolean enableIhr) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.abi = abi;
            this.address = address;
            this.srcAddress = srcAddress;
            this.deploySet = deploySet;
            this.callSet = callSet;
            this.value = value;
            this.bounce = bounce;
            this.enableIhr = enableIhr;
        }

        @NonNull
        @Generated
        public String value() {
            return this.value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncodeInternalMessage)) {
                return false;
            }
            ParamsOfEncodeInternalMessage other = (ParamsOfEncodeInternalMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Boolean> this$bounce = this.bounce();
            Optional<Boolean> other$bounce = other.bounce();
            if (this$bounce == null ? other$bounce != null : !((Object)this$bounce).equals(other$bounce)) {
                return false;
            }
            Optional<Boolean> this$enableIhr = this.enableIhr();
            Optional<Boolean> other$enableIhr = other.enableIhr();
            if (this$enableIhr == null ? other$enableIhr != null : !((Object)this$enableIhr).equals(other$enableIhr)) {
                return false;
            }
            Optional<ABI> this$abi = this.abi();
            Optional<ABI> other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
                return false;
            }
            Optional<String> this$address = this.address();
            Optional<String> other$address = other.address();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Optional<String> this$srcAddress = this.srcAddress();
            Optional<String> other$srcAddress = other.srcAddress();
            if (this$srcAddress == null ? other$srcAddress != null : !((Object)this$srcAddress).equals(other$srcAddress)) {
                return false;
            }
            Optional<DeploySet> this$deploySet = this.deploySet();
            Optional<DeploySet> other$deploySet = other.deploySet();
            if (this$deploySet == null ? other$deploySet != null : !((Object)this$deploySet).equals(other$deploySet)) {
                return false;
            }
            Optional<CallSet> this$callSet = this.callSet();
            Optional<CallSet> other$callSet = other.callSet();
            if (this$callSet == null ? other$callSet != null : !((Object)this$callSet).equals(other$callSet)) {
                return false;
            }
            String this$value = this.value();
            String other$value = other.value();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncodeInternalMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Boolean> $bounce = this.bounce();
            result = result * 59 + ($bounce == null ? 43 : ((Object)$bounce).hashCode());
            Optional<Boolean> $enableIhr = this.enableIhr();
            result = result * 59 + ($enableIhr == null ? 43 : ((Object)$enableIhr).hashCode());
            Optional<ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            Optional<String> $address = this.address();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Optional<String> $srcAddress = this.srcAddress();
            result = result * 59 + ($srcAddress == null ? 43 : ((Object)$srcAddress).hashCode());
            Optional<DeploySet> $deploySet = this.deploySet();
            result = result * 59 + ($deploySet == null ? 43 : ((Object)$deploySet).hashCode());
            Optional<CallSet> $callSet = this.callSet();
            result = result * 59 + ($callSet == null ? 43 : ((Object)$callSet).hashCode());
            String $value = this.value();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfEncodeInternalMessage(abi=" + this.abi() + ", address=" + this.address() + ", srcAddress=" + this.srcAddress() + ", deploySet=" + this.deploySet() + ", callSet=" + this.callSet() + ", value=" + this.value() + ", bounce=" + this.bounce() + ", enableIhr=" + this.enableIhr() + ")";
        }
    }

    public static final class ResultOfEncodeInternalMessage
    extends JsonData {
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="address")
        @NonNull
        private final String address;
        @SerializedName(value="message_id")
        @NonNull
        private final String messageId;

        @Generated
        public ResultOfEncodeInternalMessage(@NonNull String message, @NonNull String address, @NonNull String messageId) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.message = message;
            this.address = address;
            this.messageId = messageId;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @NonNull
        @Generated
        public String messageId() {
            return this.messageId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncodeInternalMessage)) {
                return false;
            }
            ResultOfEncodeInternalMessage other = (ResultOfEncodeInternalMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$messageId = this.messageId();
            String other$messageId = other.messageId();
            return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncodeInternalMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $messageId = this.messageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfEncodeInternalMessage(message=" + this.message() + ", address=" + this.address() + ", messageId=" + this.messageId() + ")";
        }
    }

    public static final class ParamsOfAttachSignature
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="public_key")
        @NonNull
        private final String publicKey;
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="signature")
        @NonNull
        private final String signature;

        @Generated
        public ParamsOfAttachSignature(@NonNull ABI abi, @NonNull String publicKey, @NonNull String message, @NonNull String signature) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (publicKey == null) {
                throw new NullPointerException("publicKey is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (signature == null) {
                throw new NullPointerException("signature is marked non-null but is null");
            }
            this.abi = abi;
            this.publicKey = publicKey;
            this.message = message;
            this.signature = signature;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public String publicKey() {
            return this.publicKey;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String signature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfAttachSignature)) {
                return false;
            }
            ParamsOfAttachSignature other = (ParamsOfAttachSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$publicKey = this.publicKey();
            String other$publicKey = other.publicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$signature = this.signature();
            String other$signature = other.signature();
            return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfAttachSignature;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $publicKey = this.publicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $signature = this.signature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfAttachSignature(abi=" + this.abi() + ", publicKey=" + this.publicKey() + ", message=" + this.message() + ", signature=" + this.signature() + ")";
        }
    }

    public static final class ResultOfAttachSignature
    extends JsonData {
        @SerializedName(value="message")
        @NonNull
        private final String message;
        @SerializedName(value="message_id")
        @NonNull
        private final String messageId;

        @Generated
        public ResultOfAttachSignature(@NonNull String message, @NonNull String messageId) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.message = message;
            this.messageId = messageId;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @NonNull
        @Generated
        public String messageId() {
            return this.messageId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfAttachSignature)) {
                return false;
            }
            ResultOfAttachSignature other = (ResultOfAttachSignature)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$messageId = this.messageId();
            String other$messageId = other.messageId();
            return !(this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfAttachSignature;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $messageId = this.messageId();
            result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfAttachSignature(message=" + this.message() + ", messageId=" + this.messageId() + ")";
        }
    }

    public static final class ParamsOfDecodeMessage
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="message")
        @NonNull
        private final String message;

        @Generated
        public ParamsOfDecodeMessage(@NonNull ABI abi, @NonNull String message) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.abi = abi;
            this.message = message;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public String message() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecodeMessage)) {
                return false;
            }
            ParamsOfDecodeMessage other = (ParamsOfDecodeMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecodeMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfDecodeMessage(abi=" + this.abi() + ", message=" + this.message() + ")";
        }
    }

    public static final class DecodedMessageBody
    extends JsonData {
        @SerializedName(value="body_type")
        @NonNull
        private final MessageBodyType bodyType;
        @SerializedName(value="name")
        @NonNull
        private final String name;
        @SerializedName(value="value")
        private final Map<String, Object> value;
        @SerializedName(value="header")
        private final FunctionHeader header;

        public Optional<Map<String, Object>> value() {
            return Optional.ofNullable(this.value);
        }

        public Optional<FunctionHeader> header() {
            return Optional.ofNullable(this.header);
        }

        @Generated
        public DecodedMessageBody(@NonNull MessageBodyType bodyType, @NonNull String name, Map<String, Object> value, FunctionHeader header) {
            if (bodyType == null) {
                throw new NullPointerException("bodyType is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.bodyType = bodyType;
            this.name = name;
            this.value = value;
            this.header = header;
        }

        @NonNull
        @Generated
        public MessageBodyType bodyType() {
            return this.bodyType;
        }

        @NonNull
        @Generated
        public String name() {
            return this.name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DecodedMessageBody)) {
                return false;
            }
            DecodedMessageBody other = (DecodedMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MessageBodyType this$bodyType = this.bodyType();
            MessageBodyType other$bodyType = other.bodyType();
            if (this$bodyType == null ? other$bodyType != null : !((Object)((Object)this$bodyType)).equals((Object)other$bodyType)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Optional<Map<String, Object>> this$value = this.value();
            Optional<Map<String, Object>> other$value = other.value();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            Optional<FunctionHeader> this$header = this.header();
            Optional<FunctionHeader> other$header = other.header();
            return !(this$header == null ? other$header != null : !((Object)this$header).equals(other$header));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DecodedMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            MessageBodyType $bodyType = this.bodyType();
            result = result * 59 + ($bodyType == null ? 43 : ((Object)((Object)$bodyType)).hashCode());
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Optional<Map<String, Object>> $value = this.value();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            Optional<FunctionHeader> $header = this.header();
            result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.DecodedMessageBody(bodyType=" + this.bodyType() + ", name=" + this.name() + ", value=" + this.value() + ", header=" + this.header() + ")";
        }
    }

    public static final class ParamsOfDecodeMessageBody
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="body")
        @NonNull
        private final String body;
        @SerializedName(value="is_internal")
        @NonNull
        private final Boolean isInternal;

        @Generated
        public ParamsOfDecodeMessageBody(@NonNull ABI abi, @NonNull String body, @NonNull Boolean isInternal) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (body == null) {
                throw new NullPointerException("body is marked non-null but is null");
            }
            if (isInternal == null) {
                throw new NullPointerException("isInternal is marked non-null but is null");
            }
            this.abi = abi;
            this.body = body;
            this.isInternal = isInternal;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public String body() {
            return this.body;
        }

        @NonNull
        @Generated
        public Boolean isInternal() {
            return this.isInternal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecodeMessageBody)) {
                return false;
            }
            ParamsOfDecodeMessageBody other = (ParamsOfDecodeMessageBody)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$isInternal = this.isInternal();
            Boolean other$isInternal = other.isInternal();
            if (this$isInternal == null ? other$isInternal != null : !((Object)this$isInternal).equals(other$isInternal)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$body = this.body();
            String other$body = other.body();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecodeMessageBody;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $isInternal = this.isInternal();
            result = result * 59 + ($isInternal == null ? 43 : ((Object)$isInternal).hashCode());
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $body = this.body();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfDecodeMessageBody(abi=" + this.abi() + ", body=" + this.body() + ", isInternal=" + this.isInternal() + ")";
        }
    }

    public static final class ParamsOfEncodeAccount
    extends JsonData {
        @SerializedName(value="state_init")
        @NonNull
        private final StateInitSource stateInit;
        @SerializedName(value="balance")
        private final Long balance;
        @SerializedName(value="last_trans_lt")
        private final Long lastTransLt;
        @SerializedName(value="last_paid")
        private final Number lastPaid;
        @SerializedName(value="boc_cache")
        private final Boc.BocCacheType bocCache;

        public Optional<Long> balance() {
            return Optional.ofNullable(this.balance);
        }

        public Optional<Long> lastTransLt() {
            return Optional.ofNullable(this.lastTransLt);
        }

        public Optional<Number> lastPaid() {
            return Optional.ofNullable(this.lastPaid);
        }

        public Optional<Boc.BocCacheType> bocCache() {
            return Optional.ofNullable(this.bocCache);
        }

        @Generated
        public ParamsOfEncodeAccount(@NonNull StateInitSource stateInit, Long balance, Long lastTransLt, Number lastPaid, Boc.BocCacheType bocCache) {
            if (stateInit == null) {
                throw new NullPointerException("stateInit is marked non-null but is null");
            }
            this.stateInit = stateInit;
            this.balance = balance;
            this.lastTransLt = lastTransLt;
            this.lastPaid = lastPaid;
            this.bocCache = bocCache;
        }

        @NonNull
        @Generated
        public StateInitSource stateInit() {
            return this.stateInit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncodeAccount)) {
                return false;
            }
            ParamsOfEncodeAccount other = (ParamsOfEncodeAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Long> this$balance = this.balance();
            Optional<Long> other$balance = other.balance();
            if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
                return false;
            }
            Optional<Long> this$lastTransLt = this.lastTransLt();
            Optional<Long> other$lastTransLt = other.lastTransLt();
            if (this$lastTransLt == null ? other$lastTransLt != null : !((Object)this$lastTransLt).equals(other$lastTransLt)) {
                return false;
            }
            StateInitSource this$stateInit = this.stateInit();
            StateInitSource other$stateInit = other.stateInit();
            if (this$stateInit == null ? other$stateInit != null : !this$stateInit.equals(other$stateInit)) {
                return false;
            }
            Optional<Number> this$lastPaid = this.lastPaid();
            Optional<Number> other$lastPaid = other.lastPaid();
            if (this$lastPaid == null ? other$lastPaid != null : !((Object)this$lastPaid).equals(other$lastPaid)) {
                return false;
            }
            Optional<Boc.BocCacheType> this$bocCache = this.bocCache();
            Optional<Boc.BocCacheType> other$bocCache = other.bocCache();
            return !(this$bocCache == null ? other$bocCache != null : !((Object)this$bocCache).equals(other$bocCache));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncodeAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Long> $balance = this.balance();
            result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
            Optional<Long> $lastTransLt = this.lastTransLt();
            result = result * 59 + ($lastTransLt == null ? 43 : ((Object)$lastTransLt).hashCode());
            StateInitSource $stateInit = this.stateInit();
            result = result * 59 + ($stateInit == null ? 43 : $stateInit.hashCode());
            Optional<Number> $lastPaid = this.lastPaid();
            result = result * 59 + ($lastPaid == null ? 43 : ((Object)$lastPaid).hashCode());
            Optional<Boc.BocCacheType> $bocCache = this.bocCache();
            result = result * 59 + ($bocCache == null ? 43 : ((Object)$bocCache).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfEncodeAccount(stateInit=" + this.stateInit() + ", balance=" + this.balance() + ", lastTransLt=" + this.lastTransLt() + ", lastPaid=" + this.lastPaid() + ", bocCache=" + this.bocCache() + ")";
        }
    }

    public static abstract class StateInitSource {

        public static final class Tvc
        extends StateInitSource {
            @SerializedName(value="tvc")
            @NonNull
            private final String tvc;
            @SerializedName(value="public_key")
            private final String publicKey;
            @SerializedName(value="init_params")
            private final Map<String, Object> initParams;

            public Optional<String> publicKey() {
                return Optional.ofNullable(this.publicKey);
            }

            public Optional<Map<String, Object>> initParams() {
                return Optional.ofNullable(this.initParams);
            }

            @Generated
            public Tvc(@NonNull String tvc, String publicKey, Map<String, Object> initParams) {
                if (tvc == null) {
                    throw new NullPointerException("tvc is marked non-null but is null");
                }
                this.tvc = tvc;
                this.publicKey = publicKey;
                this.initParams = initParams;
            }

            @NonNull
            @Generated
            public String tvc() {
                return this.tvc;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tvc)) {
                    return false;
                }
                Tvc other = (Tvc)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$tvc = this.tvc();
                String other$tvc = other.tvc();
                if (this$tvc == null ? other$tvc != null : !this$tvc.equals(other$tvc)) {
                    return false;
                }
                Optional<String> this$publicKey = this.publicKey();
                Optional<String> other$publicKey = other.publicKey();
                if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
                    return false;
                }
                Optional<Map<String, Object>> this$initParams = this.initParams();
                Optional<Map<String, Object>> other$initParams = other.initParams();
                return !(this$initParams == null ? other$initParams != null : !((Object)this$initParams).equals(other$initParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tvc;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $tvc = this.tvc();
                result = result * 59 + ($tvc == null ? 43 : $tvc.hashCode());
                Optional<String> $publicKey = this.publicKey();
                result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
                Optional<Map<String, Object>> $initParams = this.initParams();
                result = result * 59 + ($initParams == null ? 43 : ((Object)$initParams).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.StateInitSource.Tvc(tvc=" + this.tvc() + ", publicKey=" + this.publicKey() + ", initParams=" + this.initParams() + ")";
            }
        }

        public static final class StateInit
        extends StateInitSource {
            @SerializedName(value="code")
            @NonNull
            private final String code;
            @SerializedName(value="data")
            @NonNull
            private final String data;
            @SerializedName(value="library")
            private final String library;

            public Optional<String> library() {
                return Optional.ofNullable(this.library);
            }

            @Generated
            public StateInit(@NonNull String code, @NonNull String data, String library) {
                if (code == null) {
                    throw new NullPointerException("code is marked non-null but is null");
                }
                if (data == null) {
                    throw new NullPointerException("data is marked non-null but is null");
                }
                this.code = code;
                this.data = data;
                this.library = library;
            }

            @NonNull
            @Generated
            public String code() {
                return this.code;
            }

            @NonNull
            @Generated
            public String data() {
                return this.data;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StateInit)) {
                    return false;
                }
                StateInit other = (StateInit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                String this$code = this.code();
                String other$code = other.code();
                if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                    return false;
                }
                String this$data = this.data();
                String other$data = other.data();
                if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                    return false;
                }
                Optional<String> this$library = this.library();
                Optional<String> other$library = other.library();
                return !(this$library == null ? other$library != null : !((Object)this$library).equals(other$library));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StateInit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                String $code = this.code();
                result = result * 59 + ($code == null ? 43 : $code.hashCode());
                String $data = this.data();
                result = result * 59 + ($data == null ? 43 : $data.hashCode());
                Optional<String> $library = this.library();
                result = result * 59 + ($library == null ? 43 : ((Object)$library).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.StateInitSource.StateInit(code=" + this.code() + ", data=" + this.data() + ", library=" + this.library() + ")";
            }
        }

        public static final class Message
        extends StateInitSource {
            @SerializedName(value="source")
            @NonNull
            private final Map<String, Object> source;

            @Generated
            public Message(@NonNull Map<String, Object> source) {
                if (source == null) {
                    throw new NullPointerException("source is marked non-null but is null");
                }
                this.source = source;
            }

            @NonNull
            @Generated
            public Map<String, Object> source() {
                return this.source;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Message)) {
                    return false;
                }
                Message other = (Message)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Map<String, Object> this$source = this.source();
                Map<String, Object> other$source = other.source();
                return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Message;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Map<String, Object> $source = this.source();
                result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Abi.StateInitSource.Message(source=" + this.source() + ")";
            }
        }
    }

    public static final class ResultOfEncodeAccount
    extends JsonData {
        @SerializedName(value="account")
        @NonNull
        private final String account;
        @SerializedName(value="id")
        @NonNull
        private final String id;

        @Generated
        public ResultOfEncodeAccount(@NonNull String account, @NonNull String id) {
            if (account == null) {
                throw new NullPointerException("account is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.account = account;
            this.id = id;
        }

        @NonNull
        @Generated
        public String account() {
            return this.account;
        }

        @NonNull
        @Generated
        public String id() {
            return this.id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncodeAccount)) {
                return false;
            }
            ResultOfEncodeAccount other = (ResultOfEncodeAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$account = this.account();
            String other$account = other.account();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncodeAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $account = this.account();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfEncodeAccount(account=" + this.account() + ", id=" + this.id() + ")";
        }
    }

    public static final class ParamsOfDecodeAccountData
    extends JsonData {
        @SerializedName(value="abi")
        @NonNull
        private final ABI abi;
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ParamsOfDecodeAccountData(@NonNull ABI abi, @NonNull String data) {
            if (abi == null) {
                throw new NullPointerException("abi is marked non-null but is null");
            }
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.abi = abi;
            this.data = data;
        }

        @NonNull
        @Generated
        public ABI abi() {
            return this.abi;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecodeAccountData)) {
                return false;
            }
            ParamsOfDecodeAccountData other = (ParamsOfDecodeAccountData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ABI this$abi = this.abi();
            ABI other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !this$abi.equals(other$abi)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecodeAccountData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ABI $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : $abi.hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfDecodeAccountData(abi=" + this.abi() + ", data=" + this.data() + ")";
        }
    }

    public static final class ResultOfDecodeAccountData
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final Map<String, Object> data;

        @Generated
        public ResultOfDecodeAccountData(@NonNull Map<String, Object> data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public Map<String, Object> data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfDecodeAccountData)) {
                return false;
            }
            ResultOfDecodeAccountData other = (ResultOfDecodeAccountData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$data = this.data();
            Map<String, Object> other$data = other.data();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfDecodeAccountData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $data = this.data();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfDecodeAccountData(data=" + this.data() + ")";
        }
    }

    public static final class ParamsOfUpdateInitialData
    extends JsonData {
        @SerializedName(value="abi")
        private final ABI abi;
        @SerializedName(value="data")
        @NonNull
        private final String data;
        @SerializedName(value="initial_data")
        private final Map<String, Object> initialData;
        @SerializedName(value="initial_pubkey")
        private final String initialPubkey;
        @SerializedName(value="boc_cache")
        private final Boc.BocCacheType bocCache;

        public Optional<ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        public Optional<Map<String, Object>> initialData() {
            return Optional.ofNullable(this.initialData);
        }

        public Optional<String> initialPubkey() {
            return Optional.ofNullable(this.initialPubkey);
        }

        public Optional<Boc.BocCacheType> bocCache() {
            return Optional.ofNullable(this.bocCache);
        }

        @Generated
        public ParamsOfUpdateInitialData(ABI abi, @NonNull String data, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.abi = abi;
            this.data = data;
            this.initialData = initialData;
            this.initialPubkey = initialPubkey;
            this.bocCache = bocCache;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfUpdateInitialData)) {
                return false;
            }
            ParamsOfUpdateInitialData other = (ParamsOfUpdateInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<ABI> this$abi = this.abi();
            Optional<ABI> other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            Optional<Map<String, Object>> this$initialData = this.initialData();
            Optional<Map<String, Object>> other$initialData = other.initialData();
            if (this$initialData == null ? other$initialData != null : !((Object)this$initialData).equals(other$initialData)) {
                return false;
            }
            Optional<String> this$initialPubkey = this.initialPubkey();
            Optional<String> other$initialPubkey = other.initialPubkey();
            if (this$initialPubkey == null ? other$initialPubkey != null : !((Object)this$initialPubkey).equals(other$initialPubkey)) {
                return false;
            }
            Optional<Boc.BocCacheType> this$bocCache = this.bocCache();
            Optional<Boc.BocCacheType> other$bocCache = other.bocCache();
            return !(this$bocCache == null ? other$bocCache != null : !((Object)this$bocCache).equals(other$bocCache));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfUpdateInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            Optional<Map<String, Object>> $initialData = this.initialData();
            result = result * 59 + ($initialData == null ? 43 : ((Object)$initialData).hashCode());
            Optional<String> $initialPubkey = this.initialPubkey();
            result = result * 59 + ($initialPubkey == null ? 43 : ((Object)$initialPubkey).hashCode());
            Optional<Boc.BocCacheType> $bocCache = this.bocCache();
            result = result * 59 + ($bocCache == null ? 43 : ((Object)$bocCache).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfUpdateInitialData(abi=" + this.abi() + ", data=" + this.data() + ", initialData=" + this.initialData() + ", initialPubkey=" + this.initialPubkey() + ", bocCache=" + this.bocCache() + ")";
        }
    }

    public static final class ResultOfUpdateInitialData
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ResultOfUpdateInitialData(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfUpdateInitialData)) {
                return false;
            }
            ResultOfUpdateInitialData other = (ResultOfUpdateInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfUpdateInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfUpdateInitialData(data=" + this.data() + ")";
        }
    }

    public static final class ParamsOfEncodeInitialData
    extends JsonData {
        @SerializedName(value="abi")
        private final ABI abi;
        @SerializedName(value="initial_data")
        private final Map<String, Object> initialData;
        @SerializedName(value="initial_pubkey")
        private final String initialPubkey;
        @SerializedName(value="boc_cache")
        private final Boc.BocCacheType bocCache;

        public Optional<ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        public Optional<Map<String, Object>> initialData() {
            return Optional.ofNullable(this.initialData);
        }

        public Optional<String> initialPubkey() {
            return Optional.ofNullable(this.initialPubkey);
        }

        public Optional<Boc.BocCacheType> bocCache() {
            return Optional.ofNullable(this.bocCache);
        }

        @Generated
        public ParamsOfEncodeInitialData(ABI abi, Map<String, Object> initialData, String initialPubkey, Boc.BocCacheType bocCache) {
            this.abi = abi;
            this.initialData = initialData;
            this.initialPubkey = initialPubkey;
            this.bocCache = bocCache;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfEncodeInitialData)) {
                return false;
            }
            ParamsOfEncodeInitialData other = (ParamsOfEncodeInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<ABI> this$abi = this.abi();
            Optional<ABI> other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
                return false;
            }
            Optional<Map<String, Object>> this$initialData = this.initialData();
            Optional<Map<String, Object>> other$initialData = other.initialData();
            if (this$initialData == null ? other$initialData != null : !((Object)this$initialData).equals(other$initialData)) {
                return false;
            }
            Optional<String> this$initialPubkey = this.initialPubkey();
            Optional<String> other$initialPubkey = other.initialPubkey();
            if (this$initialPubkey == null ? other$initialPubkey != null : !((Object)this$initialPubkey).equals(other$initialPubkey)) {
                return false;
            }
            Optional<Boc.BocCacheType> this$bocCache = this.bocCache();
            Optional<Boc.BocCacheType> other$bocCache = other.bocCache();
            return !(this$bocCache == null ? other$bocCache != null : !((Object)this$bocCache).equals(other$bocCache));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfEncodeInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            Optional<Map<String, Object>> $initialData = this.initialData();
            result = result * 59 + ($initialData == null ? 43 : ((Object)$initialData).hashCode());
            Optional<String> $initialPubkey = this.initialPubkey();
            result = result * 59 + ($initialPubkey == null ? 43 : ((Object)$initialPubkey).hashCode());
            Optional<Boc.BocCacheType> $bocCache = this.bocCache();
            result = result * 59 + ($bocCache == null ? 43 : ((Object)$bocCache).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfEncodeInitialData(abi=" + this.abi() + ", initialData=" + this.initialData() + ", initialPubkey=" + this.initialPubkey() + ", bocCache=" + this.bocCache() + ")";
        }
    }

    public static final class ResultOfEncodeInitialData
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final String data;

        @Generated
        public ResultOfEncodeInitialData(@NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfEncodeInitialData)) {
                return false;
            }
            ResultOfEncodeInitialData other = (ResultOfEncodeInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfEncodeInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfEncodeInitialData(data=" + this.data() + ")";
        }
    }

    public static final class ParamsOfDecodeInitialData
    extends JsonData {
        @SerializedName(value="abi")
        private final ABI abi;
        @SerializedName(value="data")
        @NonNull
        private final String data;

        public Optional<ABI> abi() {
            return Optional.ofNullable(this.abi);
        }

        @Generated
        public ParamsOfDecodeInitialData(ABI abi, @NonNull String data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.abi = abi;
            this.data = data;
        }

        @NonNull
        @Generated
        public String data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecodeInitialData)) {
                return false;
            }
            ParamsOfDecodeInitialData other = (ParamsOfDecodeInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<ABI> this$abi = this.abi();
            Optional<ABI> other$abi = other.abi();
            if (this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi)) {
                return false;
            }
            String this$data = this.data();
            String other$data = other.data();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecodeInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<ABI> $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            String $data = this.data();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfDecodeInitialData(abi=" + this.abi() + ", data=" + this.data() + ")";
        }
    }

    public static final class ResultOfDecodeInitialData
    extends JsonData {
        @SerializedName(value="initial_data")
        private final Map<String, Object> initialData;
        @SerializedName(value="initial_pubkey")
        @NonNull
        private final String initialPubkey;

        public Optional<Map<String, Object>> initialData() {
            return Optional.ofNullable(this.initialData);
        }

        @Generated
        public ResultOfDecodeInitialData(Map<String, Object> initialData, @NonNull String initialPubkey) {
            if (initialPubkey == null) {
                throw new NullPointerException("initialPubkey is marked non-null but is null");
            }
            this.initialData = initialData;
            this.initialPubkey = initialPubkey;
        }

        @NonNull
        @Generated
        public String initialPubkey() {
            return this.initialPubkey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfDecodeInitialData)) {
                return false;
            }
            ResultOfDecodeInitialData other = (ResultOfDecodeInitialData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Map<String, Object>> this$initialData = this.initialData();
            Optional<Map<String, Object>> other$initialData = other.initialData();
            if (this$initialData == null ? other$initialData != null : !((Object)this$initialData).equals(other$initialData)) {
                return false;
            }
            String this$initialPubkey = this.initialPubkey();
            String other$initialPubkey = other.initialPubkey();
            return !(this$initialPubkey == null ? other$initialPubkey != null : !this$initialPubkey.equals(other$initialPubkey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfDecodeInitialData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Map<String, Object>> $initialData = this.initialData();
            result = result * 59 + ($initialData == null ? 43 : ((Object)$initialData).hashCode());
            String $initialPubkey = this.initialPubkey();
            result = result * 59 + ($initialPubkey == null ? 43 : $initialPubkey.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfDecodeInitialData(initialData=" + this.initialData() + ", initialPubkey=" + this.initialPubkey() + ")";
        }
    }

    public static final class ParamsOfDecodeBoc
    extends JsonData {
        @SerializedName(value="params")
        @NonNull
        private final AbiParam[] params;
        @SerializedName(value="boc")
        @NonNull
        private final String boc;
        @SerializedName(value="allow_partial")
        @NonNull
        private final Boolean allowPartial;

        @Generated
        public ParamsOfDecodeBoc(@NonNull AbiParam[] params, @NonNull String boc, @NonNull Boolean allowPartial) {
            if (params == null) {
                throw new NullPointerException("params is marked non-null but is null");
            }
            if (boc == null) {
                throw new NullPointerException("boc is marked non-null but is null");
            }
            if (allowPartial == null) {
                throw new NullPointerException("allowPartial is marked non-null but is null");
            }
            this.params = params;
            this.boc = boc;
            this.allowPartial = allowPartial;
        }

        @NonNull
        @Generated
        public AbiParam[] params() {
            return this.params;
        }

        @NonNull
        @Generated
        public String boc() {
            return this.boc;
        }

        @NonNull
        @Generated
        public Boolean allowPartial() {
            return this.allowPartial;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecodeBoc)) {
                return false;
            }
            ParamsOfDecodeBoc other = (ParamsOfDecodeBoc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$allowPartial = this.allowPartial();
            Boolean other$allowPartial = other.allowPartial();
            if (this$allowPartial == null ? other$allowPartial != null : !((Object)this$allowPartial).equals(other$allowPartial)) {
                return false;
            }
            if (!Arrays.deepEquals(this.params(), other.params())) {
                return false;
            }
            String this$boc = this.boc();
            String other$boc = other.boc();
            return !(this$boc == null ? other$boc != null : !this$boc.equals(other$boc));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecodeBoc;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $allowPartial = this.allowPartial();
            result = result * 59 + ($allowPartial == null ? 43 : ((Object)$allowPartial).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.params());
            String $boc = this.boc();
            result = result * 59 + ($boc == null ? 43 : $boc.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ParamsOfDecodeBoc(params=" + Arrays.deepToString(this.params()) + ", boc=" + this.boc() + ", allowPartial=" + this.allowPartial() + ")";
        }
    }

    public static final class AbiParam
    extends JsonData {
        @SerializedName(value="name")
        @NonNull
        private final String name;
        @SerializedName(value="type")
        @NonNull
        private final String type;
        @SerializedName(value="components")
        private final AbiParam[] components;

        public Optional<AbiParam[]> components() {
            return Optional.ofNullable(this.components);
        }

        @Generated
        public AbiParam(@NonNull String name, @NonNull String type, AbiParam[] components) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.name = name;
            this.type = type;
            this.components = components;
        }

        @NonNull
        @Generated
        public String name() {
            return this.name;
        }

        @NonNull
        @Generated
        public String type() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbiParam)) {
                return false;
            }
            AbiParam other = (AbiParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$name = this.name();
            String other$name = other.name();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.type();
            String other$type = other.type();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Optional<AbiParam[]> this$components = this.components();
            Optional<AbiParam[]> other$components = other.components();
            return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbiParam;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $name = this.name();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Optional<AbiParam[]> $components = this.components();
            result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.AbiParam(name=" + this.name() + ", type=" + this.type() + ", components=" + this.components() + ")";
        }
    }

    public static final class ResultOfDecodeBoc
    extends JsonData {
        @SerializedName(value="data")
        @NonNull
        private final Map<String, Object> data;

        @Generated
        public ResultOfDecodeBoc(@NonNull Map<String, Object> data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
        }

        @NonNull
        @Generated
        public Map<String, Object> data() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfDecodeBoc)) {
                return false;
            }
            ResultOfDecodeBoc other = (ResultOfDecodeBoc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Object> this$data = this.data();
            Map<String, Object> other$data = other.data();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfDecodeBoc;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Object> $data = this.data();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.ResultOfDecodeBoc(data=" + this.data() + ")";
        }
    }

    public static final class FunctionHeader
    extends JsonData {
        @SerializedName(value="expire")
        private final Number expire;
        @SerializedName(value="time")
        private final Long time;
        @SerializedName(value="pubkey")
        private final String pubkey;

        public Optional<Number> expire() {
            return Optional.ofNullable(this.expire);
        }

        public Optional<Long> time() {
            return Optional.ofNullable(this.time);
        }

        public Optional<String> pubkey() {
            return Optional.ofNullable(this.pubkey);
        }

        @Generated
        public FunctionHeader(Number expire, Long time, String pubkey) {
            this.expire = expire;
            this.time = time;
            this.pubkey = pubkey;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FunctionHeader)) {
                return false;
            }
            FunctionHeader other = (FunctionHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Optional<Long> this$time = this.time();
            Optional<Long> other$time = other.time();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            Optional<Number> this$expire = this.expire();
            Optional<Number> other$expire = other.expire();
            if (this$expire == null ? other$expire != null : !((Object)this$expire).equals(other$expire)) {
                return false;
            }
            Optional<String> this$pubkey = this.pubkey();
            Optional<String> other$pubkey = other.pubkey();
            return !(this$pubkey == null ? other$pubkey != null : !((Object)this$pubkey).equals(other$pubkey));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FunctionHeader;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Optional<Long> $time = this.time();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            Optional<Number> $expire = this.expire();
            result = result * 59 + ($expire == null ? 43 : ((Object)$expire).hashCode());
            Optional<String> $pubkey = this.pubkey();
            result = result * 59 + ($pubkey == null ? 43 : ((Object)$pubkey).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Abi.FunctionHeader(expire=" + this.expire() + ", time=" + this.time() + ", pubkey=" + this.pubkey() + ")";
        }
    }

    public static enum MessageBodyType {
        Input,
        Output,
        InternalOutput,
        Event;

    }
}

