/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.EndpointWithIdDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.EnhancedIncomingPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailablePaymentOptionList;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.Payin;
import tech.carpentum.sdk.payment.model.PayinAccepted;
import tech.carpentum.sdk.payment.model.PayinDetail;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;", "(Ljava/lang/String;Ltech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;)V", "availablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePaymentOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "createPayin", "Ltech/carpentum/sdk/payment/model/PayinAccepted;", "idPayin", "payin", "Ltech/carpentum/sdk/payment/model/Payin;", "getPayin", "Ltech/carpentum/sdk/payment/model/PayinDetail;", "setExternalReference", "", "reference", "AvailablePaymentOptionsBusinessValidationErrorCode", "CreatePayinBusinessValidationErrorCode", "Factory", "GetPayinBusinessValidationErrorCode", "payment-client-v2"})
public final class IncomingPaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final String apiVersion;
    @NotNull
    private final EnhancedIncomingPaymentsApi api;

    private IncomingPaymentsApi(String apiVersion, EnhancedIncomingPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailablePaymentOptionList availablePaymentOptions(@NotNull PaymentRequested paymentRequested) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        return (AvailablePaymentOptionList)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<AvailablePaymentOptionList>(this, paymentRequested){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ PaymentRequested $paymentRequested;
            {
                this.this$0 = $receiver;
                this.$paymentRequested = $paymentRequested;
                super(0);
            }

            @NotNull
            public final AvailablePaymentOptionList invoke() {
                return IncomingPaymentsApi.access$getApi$p(this.this$0).availablePaymentOptions(IncomingPaymentsApi.access$getApiVersion$p(this.this$0), this.$paymentRequested);
            }
        });
    }

    @NotNull
    public final PayinAccepted createPayin(@NotNull String idPayin, @NotNull Payin payin) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        return (PayinAccepted)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<PayinAccepted>(this, idPayin, payin){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $idPayin;
            final /* synthetic */ Payin $payin;
            {
                this.this$0 = $receiver;
                this.$idPayin = $idPayin;
                this.$payin = $payin;
                super(0);
            }

            @NotNull
            public final PayinAccepted invoke() {
                return IncomingPaymentsApi.access$getApi$p(this.this$0).createPayin(this.$idPayin, IncomingPaymentsApi.access$getApiVersion$p(this.this$0), this.$payin);
            }
        });
    }

    public final void setExternalReference(@NotNull String idPayin, @NotNull String reference) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<Unit>(this, idPayin, reference){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $idPayin;
            final /* synthetic */ String $reference;
            {
                this.this$0 = $receiver;
                this.$idPayin = $idPayin;
                this.$reference = $reference;
                super(0);
            }

            public final void invoke() {
                IncomingPaymentsApi.access$getApi$p(this.this$0).payinSetExternalReference(this.$idPayin, IncomingPaymentsApi.access$getApiVersion$p(this.this$0), new ExternalReference(this.$reference));
            }
        });
    }

    @NotNull
    public final PayinDetail getPayin(@NotNull String idPayin) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        return (PayinDetail)ResponseExceptionUtils.INSTANCE.wrap((Function0)new Function0<PayinDetail>(this, idPayin){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $idPayin;
            {
                this.this$0 = $receiver;
                this.$idPayin = $idPayin;
                super(0);
            }

            @NotNull
            public final PayinDetail invoke() {
                return IncomingPaymentsApi.access$getApi$p(this.this$0).getPayin(this.$idPayin, IncomingPaymentsApi.access$getApiVersion$p(this.this$0));
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
        return Factory.defineAvailablePaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreatePayinEndpoint() {
        return Factory.defineCreatePayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayinEndpoint() {
        return Factory.defineGetPayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineSetExternalReferenceEndpoint() {
        return Factory.defineSetExternalReferenceEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public static final /* synthetic */ EnhancedIncomingPaymentsApi access$getApi$p(IncomingPaymentsApi $this) {
        return $this.api;
    }

    public static final /* synthetic */ String access$getApiVersion$p(IncomingPaymentsApi $this) {
        return $this.apiVersion;
    }

    public /* synthetic */ IncomingPaymentsApi(String apiVersion, EnhancedIncomingPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$AvailablePaymentOptionsBusinessValidationErrorCode;", "", "(Ljava/lang/String;I)V", "CURRENCY_NOT_SUPPORTED", "CURRENCY_PRECISION_EXCEEDED", "PAYMENT_METHOD_NOT_FOUND", "PAYMENT_METHOD_ERROR", "PAYMENT_CHANNEL_NO_ACTIVE_FOUND", "PAYMENT_CHANNEL_NO_OPENED_FOUND", "PAYMENT_CHANNEL_NO_SEGMENT_FOUND", "PAYMENT_CHANNEL_AMOUNT_LIMITS", "PAYMENT_CHANNEL_DAILY_LIMITS", "payment-client-v2"})
    public static final class AvailablePaymentOptionsBusinessValidationErrorCode
    extends Enum<AvailablePaymentOptionsBusinessValidationErrorCode> {
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode CURRENCY_NOT_SUPPORTED = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode CURRENCY_PRECISION_EXCEEDED = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_METHOD_NOT_FOUND = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_METHOD_ERROR = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_CHANNEL_NO_ACTIVE_FOUND = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_CHANNEL_NO_OPENED_FOUND = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_CHANNEL_NO_SEGMENT_FOUND = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_CHANNEL_AMOUNT_LIMITS = new AvailablePaymentOptionsBusinessValidationErrorCode();
        public static final /* enum */ AvailablePaymentOptionsBusinessValidationErrorCode PAYMENT_CHANNEL_DAILY_LIMITS = new AvailablePaymentOptionsBusinessValidationErrorCode();
        private static final /* synthetic */ AvailablePaymentOptionsBusinessValidationErrorCode[] $VALUES;

        public static AvailablePaymentOptionsBusinessValidationErrorCode[] values() {
            return (AvailablePaymentOptionsBusinessValidationErrorCode[])$VALUES.clone();
        }

        public static AvailablePaymentOptionsBusinessValidationErrorCode valueOf(String value) {
            return Enum.valueOf(AvailablePaymentOptionsBusinessValidationErrorCode.class, value);
        }

        static {
            $VALUES = availablePaymentOptionsBusinessValidationErrorCodeArray = new AvailablePaymentOptionsBusinessValidationErrorCode[]{AvailablePaymentOptionsBusinessValidationErrorCode.CURRENCY_NOT_SUPPORTED, AvailablePaymentOptionsBusinessValidationErrorCode.CURRENCY_PRECISION_EXCEEDED, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_METHOD_NOT_FOUND, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_METHOD_ERROR, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_ACTIVE_FOUND, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_OPENED_FOUND, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_SEGMENT_FOUND, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_CHANNEL_AMOUNT_LIMITS, AvailablePaymentOptionsBusinessValidationErrorCode.PAYMENT_CHANNEL_DAILY_LIMITS};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000e\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$CreatePayinBusinessValidationErrorCode;", "", "(Ljava/lang/String;I)V", "CURRENCY_NOT_SUPPORTED", "CURRENCY_PRECISION_EXCEEDED", "PAYMENT_METHOD_NOT_FOUND", "PAYMENT_METHOD_ERROR", "PAYMENT_OPERATOR_NOT_FOUND", "PAYMENT_OPERATOR_CODE_INVALID", "PAYMENT_CHANNEL_NO_ACTIVE_FOUND", "PAYMENT_CHANNEL_NO_OPENED_FOUND", "PAYMENT_CHANNEL_NO_SEGMENT_FOUND", "PAYMENT_CHANNEL_AMOUNT_LIMITS", "PAYMENT_CHANNEL_DAILY_LIMITS", "IP_DENIED", "payment-client-v2"})
    public static final class CreatePayinBusinessValidationErrorCode
    extends Enum<CreatePayinBusinessValidationErrorCode> {
        public static final /* enum */ CreatePayinBusinessValidationErrorCode CURRENCY_NOT_SUPPORTED = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode CURRENCY_PRECISION_EXCEEDED = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_METHOD_NOT_FOUND = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_METHOD_ERROR = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_OPERATOR_NOT_FOUND = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_OPERATOR_CODE_INVALID = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_CHANNEL_NO_ACTIVE_FOUND = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_CHANNEL_NO_OPENED_FOUND = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_CHANNEL_NO_SEGMENT_FOUND = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_CHANNEL_AMOUNT_LIMITS = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode PAYMENT_CHANNEL_DAILY_LIMITS = new CreatePayinBusinessValidationErrorCode();
        public static final /* enum */ CreatePayinBusinessValidationErrorCode IP_DENIED = new CreatePayinBusinessValidationErrorCode();
        private static final /* synthetic */ CreatePayinBusinessValidationErrorCode[] $VALUES;

        public static CreatePayinBusinessValidationErrorCode[] values() {
            return (CreatePayinBusinessValidationErrorCode[])$VALUES.clone();
        }

        public static CreatePayinBusinessValidationErrorCode valueOf(String value) {
            return Enum.valueOf(CreatePayinBusinessValidationErrorCode.class, value);
        }

        static {
            $VALUES = createPayinBusinessValidationErrorCodeArray = new CreatePayinBusinessValidationErrorCode[]{CreatePayinBusinessValidationErrorCode.CURRENCY_NOT_SUPPORTED, CreatePayinBusinessValidationErrorCode.CURRENCY_PRECISION_EXCEEDED, CreatePayinBusinessValidationErrorCode.PAYMENT_METHOD_NOT_FOUND, CreatePayinBusinessValidationErrorCode.PAYMENT_METHOD_ERROR, CreatePayinBusinessValidationErrorCode.PAYMENT_OPERATOR_NOT_FOUND, CreatePayinBusinessValidationErrorCode.PAYMENT_OPERATOR_CODE_INVALID, CreatePayinBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_ACTIVE_FOUND, CreatePayinBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_OPENED_FOUND, CreatePayinBusinessValidationErrorCode.PAYMENT_CHANNEL_NO_SEGMENT_FOUND, CreatePayinBusinessValidationErrorCode.PAYMENT_CHANNEL_AMOUNT_LIMITS, CreatePayinBusinessValidationErrorCode.PAYMENT_CHANNEL_DAILY_LIMITS, CreatePayinBusinessValidationErrorCode.IP_DENIED};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$GetPayinBusinessValidationErrorCode;", "", "(Ljava/lang/String;I)V", "MERCHANT_INACTIVE", "payment-client-v2"})
    public static final class GetPayinBusinessValidationErrorCode
    extends Enum<GetPayinBusinessValidationErrorCode> {
        public static final /* enum */ GetPayinBusinessValidationErrorCode MERCHANT_INACTIVE = new GetPayinBusinessValidationErrorCode();
        private static final /* synthetic */ GetPayinBusinessValidationErrorCode[] $VALUES;

        public static GetPayinBusinessValidationErrorCode[] values() {
            return (GetPayinBusinessValidationErrorCode[])$VALUES.clone();
        }

        public static GetPayinBusinessValidationErrorCode valueOf(String value) {
            return Enum.valueOf(GetPayinBusinessValidationErrorCode.class, value);
        }

        static {
            $VALUES = getPayinBusinessValidationErrorCodeArray = new GetPayinBusinessValidationErrorCode[]{GetPayinBusinessValidationErrorCode.MERCHANT_INACTIVE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007\u00a8\u0006\u0011"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$Factory;", "", "()V", "create", "Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "defineAvailablePaymentOptionsEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineCreatePayinEndpoint", "Ltech/carpentum/sdk/payment/EndpointWithIdDefinition;", "defineGetPayinEndpoint", "defineSetExternalReferenceEndpoint", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.POST, "/payins/!availablePaymentOptions");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreatePayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineSetExternalReferenceEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}/!setExternalReference");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Duration duration = callTimeout;
            return new IncomingPaymentsApi(context.getApiVersion(), new EnhancedIncomingPaymentsApi(context.getApiBaseUrl(), accessToken, duration == null ? context.getDefaultCallTimeout() : duration), null);
        }

        public static /* synthetic */ IncomingPaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.IncomingPaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

