/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.QrPhMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestQrPh;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface QrPhMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.QRPH;

    @NotNull
    public AccountPayinRequestQrPh getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public static Builder builder(QrPhMethod copyOf) {
        Builder builder = QrPhMethod.builder();
        builder.account(copyOf.getAccount());
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new QrPhMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestQrPh var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public Builder paymentOperatorCode(String var1);

        @NotNull
        public Builder phoneNumber(String var1);

        @NotNull
        public QrPhMethod build();
    }
}

