/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayoutDetailImpl;
import tech.carpentum.sdk.payment.model.MoneyFee;
import tech.carpentum.sdk.payment.model.PaymentProcess;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.PayoutMethodResponse;

@JsonClass(generateAdapter=false)
public interface PayoutDetail {
    @NotNull
    public PaymentRequested getPaymentRequested();

    @NotNull
    public PaymentProcess getProcess();

    @NotNull
    public MoneyFee getFee();

    @NotNull
    public PayoutMethodResponse getPaymentMethodResponse();

    @NotNull
    public static Builder builder(PayoutDetail copyOf) {
        Builder builder = PayoutDetail.builder();
        builder.paymentRequested(copyOf.getPaymentRequested());
        builder.process(copyOf.getProcess());
        builder.fee(copyOf.getFee());
        builder.paymentMethodResponse(copyOf.getPaymentMethodResponse());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayoutDetailImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentRequested(PaymentRequested var1);

        @NotNull
        public Builder process(PaymentProcess var1);

        @NotNull
        public Builder fee(MoneyFee var1);

        @NotNull
        public Builder paymentMethodResponse(PayoutMethodResponse var1);

        @NotNull
        public PayoutDetail build();
    }
}

