/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.PaymentOption;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentOptionImpl
implements PaymentOption {
    public static final String PAYMENT_TYPE_CODE_PAYIN = "PAYIN";
    public static final String PAYMENT_TYPE_CODE_PAYOUT = "PAYOUT";
    private final String paymentTypeCode;
    private final PayinMethodCode paymentMethodCode;
    private final CurrencyCode currencyCode;
    private final Optional<SegmentCode> segmentCode;
    private final IntervalNumberTo transactionAmountLimit;
    private final Boolean isAvailable;
    private final List<@NotNull PaymentOperatorOption> paymentOperators;
    private final int hashCode;
    private final String toString;

    @Override
    public String getPaymentTypeCode() {
        return this.paymentTypeCode;
    }

    @Override
    public PayinMethodCode getPaymentMethodCode() {
        return this.paymentMethodCode;
    }

    @Override
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    @Override
    public IntervalNumberTo getTransactionAmountLimit() {
        return this.transactionAmountLimit;
    }

    @Override
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    @Override
    public List<@NotNull PaymentOperatorOption> getPaymentOperators() {
        return this.paymentOperators;
    }

    private PaymentOptionImpl(BuilderImpl builder) {
        this.paymentTypeCode = Objects.requireNonNull(builder.paymentTypeCode, "Property 'paymentTypeCode' is required.");
        this.paymentMethodCode = Objects.requireNonNull(builder.paymentMethodCode, "Property 'paymentMethodCode' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.transactionAmountLimit = Objects.requireNonNull(builder.transactionAmountLimit, "Property 'transactionAmountLimit' is required.");
        this.isAvailable = Objects.requireNonNull(builder.isAvailable, "Property 'isAvailable' is required.");
        this.paymentOperators = Collections.unmodifiableList(builder.paymentOperators);
        this.hashCode = Objects.hash(this.paymentTypeCode, this.paymentMethodCode, this.currencyCode, this.segmentCode, this.transactionAmountLimit, this.isAvailable, this.paymentOperators);
        this.toString = builder.type + "(paymentTypeCode=" + this.paymentTypeCode + ", paymentMethodCode=" + this.paymentMethodCode + ", currencyCode=" + this.currencyCode + ", segmentCode=" + this.segmentCode + ", transactionAmountLimit=" + this.transactionAmountLimit + ", isAvailable=" + this.isAvailable + ", paymentOperators=" + this.paymentOperators + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOptionImpl)) {
            return false;
        }
        PaymentOptionImpl that = (PaymentOptionImpl)obj;
        if (!this.paymentTypeCode.equals(that.paymentTypeCode)) {
            return false;
        }
        if (!this.paymentMethodCode.equals(that.paymentMethodCode)) {
            return false;
        }
        if (!this.currencyCode.equals(that.currencyCode)) {
            return false;
        }
        if (!this.segmentCode.equals(that.segmentCode)) {
            return false;
        }
        if (!this.transactionAmountLimit.equals(that.transactionAmountLimit)) {
            return false;
        }
        if (!this.isAvailable.equals(that.isAvailable)) {
            return false;
        }
        return this.paymentOperators.equals(that.paymentOperators);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentOption.Builder {
        private String paymentTypeCode = null;
        private PayinMethodCode paymentMethodCode = null;
        private CurrencyCode currencyCode = null;
        private SegmentCode segmentCode = null;
        private IntervalNumberTo transactionAmountLimit = null;
        private Boolean isAvailable = null;
        private List<@NotNull PaymentOperatorOption> paymentOperators = new ArrayList<PaymentOperatorOption>();
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentOption");
        }

        @Override
        public BuilderImpl paymentTypeCode(String paymentTypeCode) {
            this.paymentTypeCode = paymentTypeCode;
            return this;
        }

        @Override
        public BuilderImpl paymentMethodCode(PayinMethodCode paymentMethodCode) {
            this.paymentMethodCode = paymentMethodCode;
            return this;
        }

        @Override
        public BuilderImpl currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public BuilderImpl transactionAmountLimit(IntervalNumberTo transactionAmountLimit) {
            this.transactionAmountLimit = transactionAmountLimit;
            return this;
        }

        @Override
        public BuilderImpl isAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        @Override
        public BuilderImpl paymentOperators(List<@NotNull PaymentOperatorOption> paymentOperators) {
            this.paymentOperators.clear();
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAdd(PaymentOperatorOption item) {
            if (item != null) {
                this.paymentOperators.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorsAddAll(List<@NotNull PaymentOperatorOption> paymentOperators) {
            if (paymentOperators != null) {
                this.paymentOperators.addAll(paymentOperators);
            }
            return this;
        }

        @Override
        public PaymentOptionImpl build() {
            return new PaymentOptionImpl(this);
        }
    }
}

