/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.NetBankingMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestNetBanking;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface NetBankingMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.NETBANKING;

    @NotNull
    public AccountPayinRequestNetBanking getAccount();

    @NotNull
    public String getEmailAddress();

    @NotNull
    public String getPhoneNumber();

    @NotNull
    public static Builder builder(NetBankingMethod copyOf) {
        Builder builder = NetBankingMethod.builder();
        builder.account(copyOf.getAccount());
        builder.emailAddress(copyOf.getEmailAddress());
        builder.phoneNumber(copyOf.getPhoneNumber());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new NetBankingMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestNetBanking var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public Builder phoneNumber(String var1);

        @NotNull
        public NetBankingMethod build();
    }
}

