/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.UpiQRMethodResponse;

@JsonClass(generateAdapter=false)
public class UpiQRMethodResponseImpl
implements UpiQRMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final Money money;
    private final String merchantName;
    private final String reference;
    private final String qrName;
    private final String qrCode;
    private final Optional<String> upiQrDeepLink;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public Optional<String> getUpiQrDeepLink() {
        return this.upiQrDeepLink;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private UpiQRMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.upiQrDeepLink = Optional.ofNullable(builder.upiQrDeepLink);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.money, this.merchantName, this.reference, this.qrName, this.qrCode, this.upiQrDeepLink, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", money=" + this.money + ", merchantName=" + this.merchantName + ", reference=" + this.reference + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", upiQrDeepLink=" + this.upiQrDeepLink + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpiQRMethodResponseImpl)) {
            return false;
        }
        UpiQRMethodResponseImpl that = (UpiQRMethodResponseImpl)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.idPayment.equals(that.idPayment)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.merchantName.equals(that.merchantName)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.qrName.equals(that.qrName)) {
            return false;
        }
        if (!this.qrCode.equals(that.qrCode)) {
            return false;
        }
        if (!this.upiQrDeepLink.equals(that.upiQrDeepLink)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        return this.expireAt.equals(that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements UpiQRMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private Money money = null;
        private String merchantName = null;
        private String reference = null;
        private String qrName = null;
        private String qrCode = null;
        private String upiQrDeepLink = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("UpiQRMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public BuilderImpl upiQrDeepLink(String upiQrDeepLink) {
            this.upiQrDeepLink = upiQrDeepLink;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public UpiQRMethodResponseImpl build() {
            return new UpiQRMethodResponseImpl(this);
        }
    }
}

