/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.AccountResponseP2AV2;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.P2AV2MethodResponse;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentAddress;

@JsonClass(generateAdapter=false)
public class P2AV2MethodResponseImpl
implements P2AV2MethodResponse {
    private final IdPayin idPayin;
    private final AccountResponseP2AV2 account;
    private final Money money;
    private final String merchantName;
    private final PaymentAddress paymentAddress;
    private final String qrName;
    private final String qrCode;
    private final String reference;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public AccountResponseP2AV2 getAccount() {
        return this.account;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public PaymentAddress getPaymentAddress() {
        return this.paymentAddress;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private P2AV2MethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.paymentAddress = Objects.requireNonNull(builder.paymentAddress, "Property 'paymentAddress' is required.");
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.account, this.money, this.merchantName, this.paymentAddress, this.qrName, this.qrCode, this.reference, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", account=" + this.account + ", money=" + this.money + ", merchantName=" + this.merchantName + ", paymentAddress=" + this.paymentAddress + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P2AV2MethodResponseImpl)) {
            return false;
        }
        P2AV2MethodResponseImpl that = (P2AV2MethodResponseImpl)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.merchantName.equals(that.merchantName)) {
            return false;
        }
        if (!this.paymentAddress.equals(that.paymentAddress)) {
            return false;
        }
        if (!this.qrName.equals(that.qrName)) {
            return false;
        }
        if (!this.qrCode.equals(that.qrCode)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        return this.expireAt.equals(that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements P2AV2MethodResponse.Builder {
        private IdPayin idPayin = null;
        private AccountResponseP2AV2 account = null;
        private Money money = null;
        private String merchantName = null;
        private PaymentAddress paymentAddress = null;
        private String qrName = null;
        private String qrCode = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("P2AV2MethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl account(AccountResponseP2AV2 account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl paymentAddress(PaymentAddress paymentAddress) {
            this.paymentAddress = paymentAddress;
            return this;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public P2AV2MethodResponseImpl build() {
            return new P2AV2MethodResponseImpl(this);
        }
    }
}

