/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentInstruction;

@JsonClass(generateAdapter=false)
public class VaPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.VAPAY;
    @NotNull
    public final IdPayin idPayin;
    @NotNull
    public final AccountResponseWithBank account;
    @NotNull
    public final Money money;
    @NotNull
    public final String reference;
    @NotNull
    public final String returnUrl;
    @NotNull
    public final OffsetDateTime acceptedAt;
    @NotNull
    public final OffsetDateTime expireAt;
    @NotNull
    public final @NotNull List<@NotNull PaymentInstruction> paymentInstructionList;
    private final int hashCode;
    private final String toString;

    private VaPayMethodResponse(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.paymentInstructionList = Collections.unmodifiableList(builder.paymentInstructionList);
        this.hashCode = Objects.hash(new Object[]{this.idPayin, this.account, this.money, this.reference, this.returnUrl, this.acceptedAt, this.expireAt, this.paymentInstructionList, this.paymentMethodCode});
        this.toString = "VaPayMethodResponse(idPayin=" + this.idPayin + ", account=" + this.account + ", money=" + this.money + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ", paymentInstructionList=" + this.paymentInstructionList + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaPayMethodResponse)) {
            return false;
        }
        VaPayMethodResponse that = (VaPayMethodResponse)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        if (!this.expireAt.equals(that.expireAt)) {
            return false;
        }
        if (!this.paymentInstructionList.equals(that.paymentInstructionList)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IdPayin idPayin = null;
        private AccountResponseWithBank account = null;
        private Money money = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private List<@NotNull PaymentInstruction> paymentInstructionList = new ArrayList<PaymentInstruction>();

        private Builder() {
        }

        public Builder idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        public Builder account(AccountResponseWithBank account) {
            this.account = account;
            return this;
        }

        public Builder money(Money money) {
            this.money = money;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public Builder paymentInstructionList(List<@NotNull PaymentInstruction> paymentInstructionList) {
            this.paymentInstructionList.clear();
            if (paymentInstructionList != null) {
                this.paymentInstructionList.addAll(paymentInstructionList);
            }
            return this;
        }

        public Builder paymentInstructionListAdd(PaymentInstruction item) {
            if (item != null) {
                this.paymentInstructionList.add(item);
            }
            return this;
        }

        public Builder paymentInstructionListAddAll(List<@NotNull PaymentInstruction> paymentInstructionList) {
            if (paymentInstructionList != null) {
                this.paymentInstructionList.addAll(paymentInstructionList);
            }
            return this;
        }

        public VaPayMethodResponse build() {
            return new VaPayMethodResponse(this);
        }
    }
}

