/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class UpiQRMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.UPIQR;
    @NotNull
    public final Optional<String> emailAddress;
    @NotNull
    public final Optional<String> paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    private UpiQRMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.hashCode = Objects.hash(new Object[]{this.emailAddress, this.paymentOperatorCode, this.paymentMethodCode});
        this.toString = "UpiQRMethod(emailAddress=" + this.emailAddress + ", paymentOperatorCode=" + this.paymentOperatorCode + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpiQRMethod)) {
            return false;
        }
        UpiQRMethod that = (UpiQRMethod)obj;
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String emailAddress = null;
        private String paymentOperatorCode = null;

        private Builder() {
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        public UpiQRMethod build() {
            return new UpiQRMethod(this);
        }
    }
}

