/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestQrisPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class QrisPayMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.QRISPAY;
    @NotNull
    public final Optional<AccountPayinRequestQrisPay> account;
    @NotNull
    public final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    private QrisPayMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.account = Optional.ofNullable(builder.account);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(new Object[]{this.account, this.emailAddress, this.paymentMethodCode});
        this.toString = "QrisPayMethod(account=" + this.account + ", emailAddress=" + this.emailAddress + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QrisPayMethod)) {
            return false;
        }
        QrisPayMethod that = (QrisPayMethod)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AccountPayinRequestQrisPay account = null;
        private String emailAddress = null;

        private Builder() {
        }

        public Builder account(AccountPayinRequestQrisPay account) {
            this.account = account;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public QrisPayMethod build() {
            return new QrisPayMethod(this);
        }
    }
}

