/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.FailureReasons;
import tech.carpentum.sdk.payment.model.PaymentStatus;

@JsonClass(generateAdapter=false)
public class PaymentProcess {
    @NotNull
    public final PaymentStatus status;
    @NotNull
    public final Optional<FailureReasons> failureReasons;
    @NotNull
    public final OffsetDateTime createdAt;
    @NotNull
    public final Optional<OffsetDateTime> processedAt;
    @NotNull
    public final Boolean isTest;
    private final int hashCode;
    private final String toString;

    private PaymentProcess(Builder builder) {
        this.status = Objects.requireNonNull(builder.status, "Property 'status' is required.");
        this.failureReasons = Optional.ofNullable(builder.failureReasons);
        this.createdAt = Objects.requireNonNull(builder.createdAt, "Property 'createdAt' is required.");
        this.processedAt = Optional.ofNullable(builder.processedAt);
        this.isTest = Objects.requireNonNull(builder.isTest, "Property 'isTest' is required.");
        this.hashCode = Objects.hash(this.status, this.failureReasons, this.createdAt, this.processedAt, this.isTest);
        this.toString = "PaymentProcess(status=" + this.status + ", failureReasons=" + this.failureReasons + ", createdAt=" + this.createdAt + ", processedAt=" + this.processedAt + ", isTest=" + this.isTest + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentProcess)) {
            return false;
        }
        PaymentProcess that = (PaymentProcess)obj;
        if (!this.status.equals(that.status)) {
            return false;
        }
        if (!this.failureReasons.equals(that.failureReasons)) {
            return false;
        }
        if (!this.createdAt.equals(that.createdAt)) {
            return false;
        }
        if (!this.processedAt.equals(that.processedAt)) {
            return false;
        }
        return this.isTest.equals(that.isTest);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PaymentStatus status = null;
        private FailureReasons failureReasons = null;
        private OffsetDateTime createdAt = null;
        private OffsetDateTime processedAt = null;
        private Boolean isTest = null;

        private Builder() {
        }

        public Builder status(PaymentStatus status) {
            this.status = status;
            return this;
        }

        public Builder failureReasons(FailureReasons failureReasons) {
            this.failureReasons = failureReasons;
            return this;
        }

        public Builder createdAt(OffsetDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder processedAt(OffsetDateTime processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        public Builder isTest(Boolean isTest) {
            this.isTest = isTest;
            return this;
        }

        public PaymentProcess build() {
            return new PaymentProcess(this);
        }
    }
}

