/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;

@JsonClass(generateAdapter=false)
public class PaymentOperatorOption {
    @NotNull
    public final String code;
    @NotNull
    public final Optional<String> name;
    @NotNull
    public final Boolean isAvailable;
    @NotNull
    public final IntervalNumberTo transactionAmountLimit;
    private final int hashCode;
    private final String toString;

    private PaymentOperatorOption(Builder builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.name = Optional.ofNullable(builder.name);
        this.isAvailable = Objects.requireNonNull(builder.isAvailable, "Property 'isAvailable' is required.");
        this.transactionAmountLimit = Objects.requireNonNull(builder.transactionAmountLimit, "Property 'transactionAmountLimit' is required.");
        this.hashCode = Objects.hash(this.code, this.name, this.isAvailable, this.transactionAmountLimit);
        this.toString = "PaymentOperatorOption(code=" + this.code + ", name=" + this.name + ", isAvailable=" + this.isAvailable + ", transactionAmountLimit=" + this.transactionAmountLimit + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOperatorOption)) {
            return false;
        }
        PaymentOperatorOption that = (PaymentOperatorOption)obj;
        if (!this.code.equals(that.code)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.isAvailable.equals(that.isAvailable)) {
            return false;
        }
        return this.transactionAmountLimit.equals(that.transactionAmountLimit);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String code = null;
        private String name = null;
        private Boolean isAvailable = null;
        private IntervalNumberTo transactionAmountLimit = null;

        private Builder() {
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        public Builder transactionAmountLimit(IntervalNumberTo transactionAmountLimit) {
            this.transactionAmountLimit = transactionAmountLimit;
            return this;
        }

        public PaymentOperatorOption build() {
            return new PaymentOperatorOption(this);
        }
    }
}

