/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.PaymentMethod;

@JsonClass(generateAdapter=false)
public class PaymentMethodsList {
    @NotNull
    public final @NotNull List<@NotNull PaymentMethod> data;
    private final int hashCode;
    private final String toString;

    private PaymentMethodsList(Builder builder) {
        this.data = Collections.unmodifiableList(builder.data);
        this.hashCode = Objects.hash(this.data);
        this.toString = "PaymentMethodsList(data=" + this.data + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentMethodsList)) {
            return false;
        }
        PaymentMethodsList that = (PaymentMethodsList)obj;
        return this.data.equals(that.data);
    }

    public String toString() {
        return this.toString;
    }

    public static PaymentMethodsList ofData(List<@NotNull PaymentMethod> data) {
        return PaymentMethodsList.builder().data(data).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<@NotNull PaymentMethod> data = new ArrayList<PaymentMethod>();

        private Builder() {
        }

        public Builder data(List<@NotNull PaymentMethod> data) {
            this.data.clear();
            if (data != null) {
                this.data.addAll(data);
            }
            return this;
        }

        public Builder dataAdd(PaymentMethod item) {
            if (item != null) {
                this.data.add(item);
            }
            return this;
        }

        public Builder dataAddAll(List<@NotNull PaymentMethod> data) {
            if (data != null) {
                this.data.addAll(data);
            }
            return this;
        }

        public PaymentMethodsList build() {
            return new PaymentMethodsList(this);
        }
    }
}

