/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class PaymentInstruction {
    @NotNull
    public final String bankingService;
    @NotNull
    public final String companyCode;
    private final int hashCode;
    private final String toString;

    private PaymentInstruction(Builder builder) {
        this.bankingService = Objects.requireNonNull(builder.bankingService, "Property 'bankingService' is required.");
        this.companyCode = Objects.requireNonNull(builder.companyCode, "Property 'companyCode' is required.");
        this.hashCode = Objects.hash(this.bankingService, this.companyCode);
        this.toString = "PaymentInstruction(bankingService=" + this.bankingService + ", companyCode=" + this.companyCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentInstruction)) {
            return false;
        }
        PaymentInstruction that = (PaymentInstruction)obj;
        if (!this.bankingService.equals(that.bankingService)) {
            return false;
        }
        return this.companyCode.equals(that.companyCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String bankingService = null;
        private String companyCode = null;

        private Builder() {
        }

        public Builder bankingService(String bankingService) {
            this.bankingService = bankingService;
            return this;
        }

        public Builder companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public PaymentInstruction build() {
            return new PaymentInstruction(this);
        }
    }
}

