/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountResponseOnlyWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;

@JsonClass(generateAdapter=false)
public class OnlineMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.ONLINE;
    @NotNull
    public final IdPayin idPayin;
    @NotNull
    public final AccountResponseOnlyWithBank account;
    @NotNull
    public final Money money;
    @NotNull
    public final Optional<Money> moneyRequired;
    @NotNull
    public final String reference;
    @NotNull
    public final String returnUrl;
    @NotNull
    public final OffsetDateTime acceptedAt;
    @NotNull
    public final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    private OnlineMethodResponse(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(new Object[]{this.idPayin, this.account, this.money, this.moneyRequired, this.reference, this.returnUrl, this.acceptedAt, this.expireAt, this.paymentMethodCode});
        this.toString = "OnlineMethodResponse(idPayin=" + this.idPayin + ", account=" + this.account + ", money=" + this.money + ", moneyRequired=" + this.moneyRequired + ", reference=" + this.reference + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OnlineMethodResponse)) {
            return false;
        }
        OnlineMethodResponse that = (OnlineMethodResponse)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.moneyRequired.equals(that.moneyRequired)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        if (!this.expireAt.equals(that.expireAt)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IdPayin idPayin = null;
        private AccountResponseOnlyWithBank account = null;
        private Money money = null;
        private Money moneyRequired = null;
        private String reference = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;

        private Builder() {
        }

        public Builder idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        public Builder account(AccountResponseOnlyWithBank account) {
            this.account = account;
            return this;
        }

        public Builder money(Money money) {
            this.money = money;
            return this;
        }

        public Builder moneyRequired(Money moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        public Builder acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        public OnlineMethodResponse build() {
            return new OnlineMethodResponse(this);
        }
    }
}

