/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestNetBanking;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class NetBankingMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.NETBANKING;
    @NotNull
    public final AccountPayinRequestNetBanking account;
    @NotNull
    public final String emailAddress;
    @NotNull
    public final String phoneNumber;
    private final int hashCode;
    private final String toString;

    private NetBankingMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Objects.requireNonNull(builder.emailAddress, "Property 'emailAddress' is required.");
        this.phoneNumber = Objects.requireNonNull(builder.phoneNumber, "Property 'phoneNumber' is required.");
        this.hashCode = Objects.hash(new Object[]{this.account, this.emailAddress, this.phoneNumber, this.paymentMethodCode});
        this.toString = "NetBankingMethod(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetBankingMethod)) {
            return false;
        }
        NetBankingMethod that = (NetBankingMethod)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AccountPayinRequestNetBanking account = null;
        private String emailAddress = null;
        private String phoneNumber = null;

        private Builder() {
        }

        public Builder account(AccountPayinRequestNetBanking account) {
            this.account = account;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public NetBankingMethod build() {
            return new NetBankingMethod(this);
        }
    }
}

