/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public class Money {
    @NotNull
    public final BigDecimal amount;
    @NotNull
    public final CurrencyCode currencyCode;
    private final int hashCode;
    private final String toString;

    private Money(Builder builder) {
        this.amount = Objects.requireNonNull(builder.amount, "Property 'amount' is required.");
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.hashCode = Objects.hash(this.amount, this.currencyCode);
        this.toString = "Money(amount=" + this.amount + ", currencyCode=" + this.currencyCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Money)) {
            return false;
        }
        Money that = (Money)obj;
        if (!this.amount.equals(that.amount)) {
            return false;
        }
        return this.currencyCode.equals(that.currencyCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BigDecimal amount = null;
        private CurrencyCode currencyCode = null;

        private Builder() {
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Money build() {
            return new Money(this);
        }
    }
}

