/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class IntervalNumberTo {
    @NotNull
    public final Optional<BigDecimal> from;
    @NotNull
    public final Optional<BigDecimal> to;
    private final int hashCode;
    private final String toString;

    private IntervalNumberTo(Builder builder) {
        this.from = Optional.ofNullable(builder.from);
        this.to = Optional.ofNullable(builder.to);
        this.hashCode = Objects.hash(this.from, this.to);
        this.toString = "IntervalNumberTo(from=" + this.from + ", to=" + this.to + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntervalNumberTo)) {
            return false;
        }
        IntervalNumberTo that = (IntervalNumberTo)obj;
        if (!this.from.equals(that.from)) {
            return false;
        }
        return this.to.equals(that.to);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BigDecimal from = null;
        private BigDecimal to = null;

        private Builder() {
        }

        public Builder from(BigDecimal from) {
            this.from = from;
            return this;
        }

        public Builder to(BigDecimal to) {
            this.to = to;
            return this;
        }

        public IntervalNumberTo build() {
            return new IntervalNumberTo(this);
        }
    }
}

