/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.Money;

@JsonClass(generateAdapter=false)
public class CustomerTransactionFee {
    @NotNull
    public final Optional<Money> minFee;
    @NotNull
    public final Optional<Money> maxFee;
    private final int hashCode;
    private final String toString;

    private CustomerTransactionFee(Builder builder) {
        this.minFee = Optional.ofNullable(builder.minFee);
        this.maxFee = Optional.ofNullable(builder.maxFee);
        this.hashCode = Objects.hash(this.minFee, this.maxFee);
        this.toString = "CustomerTransactionFee(minFee=" + this.minFee + ", maxFee=" + this.maxFee + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerTransactionFee)) {
            return false;
        }
        CustomerTransactionFee that = (CustomerTransactionFee)obj;
        if (!this.minFee.equals(that.minFee)) {
            return false;
        }
        return this.maxFee.equals(that.maxFee);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Money minFee = null;
        private Money maxFee = null;

        private Builder() {
        }

        public Builder minFee(Money minFee) {
            this.minFee = minFee;
            return this;
        }

        public Builder maxFee(Money maxFee) {
            this.maxFee = maxFee;
            return this;
        }

        public CustomerTransactionFee build() {
            return new CustomerTransactionFee(this);
        }
    }
}

