/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public class Currency {
    @NotNull
    public final CurrencyCode code;
    private final int hashCode;
    private final String toString;

    private Currency(Builder builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.hashCode = Objects.hash(this.code);
        this.toString = "Currency(code=" + this.code + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Currency)) {
            return false;
        }
        Currency that = (Currency)obj;
        return this.code.equals(that.code);
    }

    public String toString() {
        return this.toString;
    }

    public static Currency ofCode(CurrencyCode code) {
        return Currency.builder().code(code).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CurrencyCode code = null;

        private Builder() {
        }

        public Builder code(CurrencyCode code) {
            this.code = code;
            return this;
        }

        public Currency build() {
            return new Currency(this);
        }
    }
}

