/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestCryptoTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class CryptoTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.CRYPTO_TRANSFER;
    @NotNull
    public final AccountPayoutRequestCryptoTransfer account;
    @NotNull
    public final String paymentOperatorCode;
    @NotNull
    public final Optional<String> remark;
    private final int hashCode;
    private final String toString;

    private CryptoTransferMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.remark = Optional.ofNullable(builder.remark);
        this.hashCode = Objects.hash(new Object[]{this.account, this.paymentOperatorCode, this.remark, this.paymentMethodCode});
        this.toString = "CryptoTransferMethod(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", remark=" + this.remark + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CryptoTransferMethod)) {
            return false;
        }
        CryptoTransferMethod that = (CryptoTransferMethod)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        if (!this.remark.equals(that.remark)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AccountPayoutRequestCryptoTransfer account = null;
        private String paymentOperatorCode = null;
        private String remark = null;

        private Builder() {
        }

        public Builder account(AccountPayoutRequestCryptoTransfer account) {
            this.account = account;
            return this;
        }

        public Builder paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        public Builder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public CryptoTransferMethod build() {
            return new CryptoTransferMethod(this);
        }
    }
}

