/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestBankTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public class BankTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.BANK_TRANSFER;
    @NotNull
    public final AccountPayoutRequestBankTransfer account;
    @NotNull
    public final String paymentOperatorCode;
    @NotNull
    public final Optional<String> emailAddress;
    @NotNull
    public final Optional<String> remark;
    private final int hashCode;
    private final String toString;

    private BankTransferMethod(Builder builder) {
        super(PAYMENT_METHOD_CODE);
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.remark = Optional.ofNullable(builder.remark);
        this.hashCode = Objects.hash(new Object[]{this.account, this.paymentOperatorCode, this.emailAddress, this.remark, this.paymentMethodCode});
        this.toString = "BankTransferMethod(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ", remark=" + this.remark + ", paymentMethodCode=" + (Object)((Object)this.paymentMethodCode) + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BankTransferMethod)) {
            return false;
        }
        BankTransferMethod that = (BankTransferMethod)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        if (!this.remark.equals(that.remark)) {
            return false;
        }
        return this.paymentMethodCode.equals((Object)that.paymentMethodCode);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AccountPayoutRequestBankTransfer account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private String remark = null;

        private Builder() {
        }

        public Builder account(AccountPayoutRequestBankTransfer account) {
            this.account = account;
            return this;
        }

        public Builder paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public BankTransferMethod build() {
            return new BankTransferMethod(this);
        }
    }
}

