/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonClass(generateAdapter=false)
public class AuthTokenRequest {
    @NotNull
    public final String merchantCode;
    @NotNull
    public final String secret;
    @NotNull
    public final Optional<Integer> validitySecs;
    @NotNull
    public final @NotNull List<@NotNull String> operations;
    private final int hashCode;
    private final String toString;

    private AuthTokenRequest(Builder builder) {
        this.merchantCode = Objects.requireNonNull(builder.merchantCode, "Property 'merchantCode' is required.");
        this.secret = Objects.requireNonNull(builder.secret, "Property 'secret' is required.");
        this.validitySecs = Optional.ofNullable(builder.validitySecs);
        this.operations = Collections.unmodifiableList(builder.operations);
        this.hashCode = Objects.hash(this.merchantCode, this.secret, this.validitySecs, this.operations);
        this.toString = "AuthTokenRequest(merchantCode=" + this.merchantCode + ", secret=" + this.secret + ", validitySecs=" + this.validitySecs + ", operations=" + this.operations + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthTokenRequest)) {
            return false;
        }
        AuthTokenRequest that = (AuthTokenRequest)obj;
        if (!this.merchantCode.equals(that.merchantCode)) {
            return false;
        }
        if (!this.secret.equals(that.secret)) {
            return false;
        }
        if (!this.validitySecs.equals(that.validitySecs)) {
            return false;
        }
        return this.operations.equals(that.operations);
    }

    public String toString() {
        return this.toString;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String merchantCode = null;
        private String secret = null;
        private Integer validitySecs = null;
        private List<@NotNull String> operations = new ArrayList<String>();

        private Builder() {
        }

        public Builder merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        public Builder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder validitySecs(Integer validitySecs) {
            this.validitySecs = validitySecs;
            return this;
        }

        public Builder operations(List<@NotNull String> operations) {
            this.operations.clear();
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        public Builder operationsAdd(String item) {
            if (item != null) {
                this.operations.add(item);
            }
            return this;
        }

        public Builder operationsAddAll(List<@NotNull String> operations) {
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        public AuthTokenRequest build() {
            return new AuthTokenRequest(this);
        }
    }
}

