/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.PaymentOptionJson;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.PaymentOption;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/PaymentOptionJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/PaymentOption;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/PaymentOptionJson;", "toJson", "model", "payment-client-v2"})
public final class PaymentOptionJsonAdapter {
    @FromJson
    @NotNull
    public final PaymentOption fromJson(@NotNull PaymentOptionJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        PaymentOption.Builder builder = PaymentOption.builder();
        builder.paymentTypeCode(json.getPaymentTypeCode());
        builder.paymentMethodCode(json.getPaymentMethodCode());
        builder.currencyCode(json.getCurrencyCode());
        builder.segmentCode(json.getSegmentCode());
        builder.transactionAmountLimit(json.getTransactionAmountLimit());
        builder.isAvailable(json.isAvailable());
        List<PaymentOperatorOption> list = json.getPaymentOperators();
        builder.paymentOperators(list == null ? null : CollectionsKt.toList((Iterable)list));
        PaymentOption paymentOption = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)paymentOption, (String)"builder.build()");
        return paymentOption;
    }

    @ToJson
    @NotNull
    public final PaymentOptionJson toJson(@NotNull PaymentOption model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PaymentOptionJson json = new PaymentOptionJson();
        json.setPaymentTypeCode(model.paymentTypeCode);
        json.setPaymentMethodCode(model.paymentMethodCode);
        json.setCurrencyCode(model.currencyCode);
        json.setSegmentCode(model.segmentCode.orElse(null));
        json.setTransactionAmountLimit(model.transactionAmountLimit);
        json.setAvailable(model.isAvailable);
        PaymentOptionJson paymentOptionJson = json;
        Collection collection2 = model.paymentOperators;
        if (collection2.isEmpty()) {
            PaymentOptionJson paymentOptionJson2 = paymentOptionJson;
            boolean bl = false;
            collection = null;
            paymentOptionJson = paymentOptionJson2;
        } else {
            collection = collection2;
        }
        paymentOptionJson.setPaymentOperators((List)collection);
        return json;
    }
}

