/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.json;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.json.PayinJson;
import tech.carpentum.sdk.payment.model.Payin;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0007\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/json/PayinJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/Payin;", "json", "Ltech/carpentum/sdk/payment/internal/generated/json/PayinJson;", "toJson", "model", "payment-client-v2"})
public final class PayinJsonAdapter {
    @FromJson
    @NotNull
    public final Payin fromJson(@NotNull PayinJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Payin.Builder builder = Payin.builder();
        builder.paymentRequested(json.getPaymentRequested());
        builder.paymentMethod(json.getPaymentMethod());
        builder.callbackUrl(json.getCallbackUrl());
        builder.returnUrl(json.getReturnUrl());
        builder.customerIp(json.getCustomerIp());
        Payin payin = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)payin, (String)"builder.build()");
        return payin;
    }

    @ToJson
    @NotNull
    public final PayinJson toJson(@NotNull Payin model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PayinJson json = new PayinJson();
        json.setPaymentRequested(model.paymentRequested);
        json.setPaymentMethod(model.paymentMethod);
        json.setCallbackUrl(model.callbackUrl.orElse(null));
        json.setReturnUrl(model.returnUrl);
        json.setCustomerIp(model.customerIp.orElse(null));
        return json;
    }
}

