/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.EndpointDefinition;
import tech.carpentum.sdk.payment.EndpointWithIdDefinition;
import tech.carpentum.sdk.payment.PaymentContext;
import tech.carpentum.sdk.payment.ResponseException;
import tech.carpentum.sdk.payment.internal.api.ClientErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.EnhancedIncomingPaymentsApi;
import tech.carpentum.sdk.payment.internal.api.GetPayinErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostAvailablePaymentOptionsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.PostPayinsErrorExceptionFactory;
import tech.carpentum.sdk.payment.internal.api.ResponseExceptionUtils;
import tech.carpentum.sdk.payment.model.AvailablePaymentOptionList;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.Payin;
import tech.carpentum.sdk.payment.model.PayinAcceptedResponse;
import tech.carpentum.sdk.payment.model.PayinDetail;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "", "apiVersion", "", "api", "Ltech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;", "(ILtech/carpentum/sdk/payment/internal/api/EnhancedIncomingPaymentsApi;)V", "availablePaymentOptions", "Ltech/carpentum/sdk/payment/model/AvailablePaymentOptionList;", "paymentRequested", "Ltech/carpentum/sdk/payment/model/PaymentRequested;", "createPayin", "Ltech/carpentum/sdk/payment/model/PayinAcceptedResponse;", "idPayin", "", "payin", "Ltech/carpentum/sdk/payment/model/Payin;", "getPayin", "Ltech/carpentum/sdk/payment/model/PayinDetail;", "setExternalReference", "", "reference", "Factory", "payment-client-v2"})
public final class IncomingPaymentsApi {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final int apiVersion;
    @NotNull
    private final EnhancedIncomingPaymentsApi api;

    private IncomingPaymentsApi(int apiVersion, EnhancedIncomingPaymentsApi api) {
        this.apiVersion = apiVersion;
        this.api = api;
    }

    @NotNull
    public final AvailablePaymentOptionList availablePaymentOptions(@NotNull PaymentRequested paymentRequested) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)paymentRequested, (String)"paymentRequested");
        return (AvailablePaymentOptionList)ResponseExceptionUtils.INSTANCE.wrap(PostAvailablePaymentOptionsErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<AvailablePaymentOptionList>(this, paymentRequested){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ PaymentRequested $paymentRequested;
            {
                this.this$0 = $receiver;
                this.$paymentRequested = $paymentRequested;
                super(0);
            }

            @NotNull
            public final AvailablePaymentOptionList invoke() {
                return IncomingPaymentsApi.access$getApi$p(this.this$0).payinAvailablePaymentOptions(IncomingPaymentsApi.access$getApiVersion$p(this.this$0), this.$paymentRequested);
            }
        });
    }

    @NotNull
    public final PayinAcceptedResponse createPayin(@NotNull String idPayin, @NotNull Payin payin) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)payin, (String)"payin");
        return (PayinAcceptedResponse)ResponseExceptionUtils.INSTANCE.wrap(PostPayinsErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<PayinAcceptedResponse>(this, idPayin, payin){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $idPayin;
            final /* synthetic */ Payin $payin;
            {
                this.this$0 = $receiver;
                this.$idPayin = $idPayin;
                this.$payin = $payin;
                super(0);
            }

            @NotNull
            public final PayinAcceptedResponse invoke() {
                EnhancedIncomingPaymentsApi enhancedIncomingPaymentsApi = IncomingPaymentsApi.access$getApi$p(this.this$0);
                int n = IncomingPaymentsApi.access$getApiVersion$p(this.this$0);
                return enhancedIncomingPaymentsApi.createPayin(n, this.$idPayin, this.$payin);
            }
        });
    }

    public final void setExternalReference(@NotNull String idPayin, @NotNull String reference) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        ResponseExceptionUtils.INSTANCE.wrap(ClientErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<Unit>(this, reference, idPayin){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $reference;
            final /* synthetic */ String $idPayin;
            {
                this.this$0 = $receiver;
                this.$reference = $reference;
                this.$idPayin = $idPayin;
                super(0);
            }

            public final void invoke() {
                EnhancedIncomingPaymentsApi enhancedIncomingPaymentsApi = IncomingPaymentsApi.access$getApi$p(this.this$0);
                int n = IncomingPaymentsApi.access$getApiVersion$p(this.this$0);
                ExternalReference externalReference = ExternalReference.ofReference(this.$reference);
                Intrinsics.checkNotNullExpressionValue((Object)externalReference, (String)"ofReference(reference)");
                enhancedIncomingPaymentsApi.payinSetExternalReference(n, this.$idPayin, externalReference);
            }
        });
    }

    @NotNull
    public final PayinDetail getPayin(@NotNull String idPayin) throws ResponseException {
        Intrinsics.checkNotNullParameter((Object)idPayin, (String)"idPayin");
        return (PayinDetail)ResponseExceptionUtils.INSTANCE.wrap(GetPayinErrorExceptionFactory.Companion.getInstance(), (Function0)new Function0<PayinDetail>(this, idPayin){
            final /* synthetic */ IncomingPaymentsApi this$0;
            final /* synthetic */ String $idPayin;
            {
                this.this$0 = $receiver;
                this.$idPayin = $idPayin;
                super(0);
            }

            @NotNull
            public final PayinDetail invoke() {
                EnhancedIncomingPaymentsApi enhancedIncomingPaymentsApi = IncomingPaymentsApi.access$getApi$p(this.this$0);
                int n = IncomingPaymentsApi.access$getApiVersion$p(this.this$0);
                return enhancedIncomingPaymentsApi.getPayin(n, this.$idPayin);
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
        return Factory.defineAvailablePaymentOptionsEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineCreatePayinEndpoint() {
        return Factory.defineCreatePayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineGetPayinEndpoint() {
        return Factory.defineGetPayinEndpoint();
    }

    @JvmStatic
    @NotNull
    public static final EndpointWithIdDefinition defineSetExternalReferenceEndpoint() {
        return Factory.defineSetExternalReferenceEndpoint();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
        return Factory.create(context, accessToken, callTimeout);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
        return Factory.create(context, accessToken);
    }

    public static final /* synthetic */ EnhancedIncomingPaymentsApi access$getApi$p(IncomingPaymentsApi $this) {
        return $this.api;
    }

    public static final /* synthetic */ int access$getApiVersion$p(IncomingPaymentsApi $this) {
        return $this.apiVersion;
    }

    public /* synthetic */ IncomingPaymentsApi(int apiVersion, EnhancedIncomingPaymentsApi api, DefaultConstructorMarker $constructor_marker) {
        this(apiVersion, api);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007\u00a8\u0006\u0011"}, d2={"Ltech/carpentum/sdk/payment/IncomingPaymentsApi$Factory;", "", "()V", "create", "Ltech/carpentum/sdk/payment/IncomingPaymentsApi;", "context", "Ltech/carpentum/sdk/payment/PaymentContext;", "accessToken", "", "callTimeout", "Ljava/time/Duration;", "defineAvailablePaymentOptionsEndpoint", "Ltech/carpentum/sdk/payment/EndpointDefinition;", "defineCreatePayinEndpoint", "Ltech/carpentum/sdk/payment/EndpointWithIdDefinition;", "defineGetPayinEndpoint", "defineSetExternalReferenceEndpoint", "payment-client-v2"})
    public static final class Factory {
        private Factory() {
        }

        @JvmStatic
        @NotNull
        public final EndpointDefinition defineAvailablePaymentOptionsEndpoint() {
            return new EndpointDefinition(EndpointDefinition.Method.POST, "/payins/!availablePaymentOptions");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineCreatePayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineGetPayinEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.GET, "/payins/{id}");
        }

        @JvmStatic
        @NotNull
        public final EndpointWithIdDefinition defineSetExternalReferenceEndpoint() {
            return new EndpointWithIdDefinition(EndpointDefinition.Method.POST, "/payins/{id}/!setExternalReference");
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken, @Nullable Duration callTimeout) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            int n = context.getApiVersion();
            String string = context.getApiBaseUrl();
            Duration duration = callTimeout;
            if (duration == null) {
                duration = context.getDefaultCallTimeout();
            }
            return new IncomingPaymentsApi(n, new EnhancedIncomingPaymentsApi(string, accessToken, duration), null);
        }

        public static /* synthetic */ IncomingPaymentsApi create$default(Factory factory, PaymentContext paymentContext, String string, Duration duration, int n, Object object) {
            if ((n & 4) != 0) {
                duration = null;
            }
            return factory.create(paymentContext, string, duration);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final IncomingPaymentsApi create(@NotNull PaymentContext context, @NotNull String accessToken) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            return tech.carpentum.sdk.payment.IncomingPaymentsApi$Factory.create$default(this, context, accessToken, null, 4, null);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

