/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.OfflineMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseOffline;
import tech.carpentum.sdk.payment.model.AccountResponseOffline;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyRequired;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentProcessor;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface OfflineMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.OFFLINE;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseOffline getAccount();

    @NotNull
    public AccountCustomerResponseOffline getAccountCustomer();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyRequired> getMoneyRequired();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public Optional<PaymentProcessor> getProcessor();

    @NotNull
    public Optional<String> getQrName();

    @NotNull
    public Optional<String> getQrCode();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getProductId();

    @NotNull
    public Optional<String> getTaxId();

    @NotNull
    public Optional<String> getTaxIdCustomer();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(OfflineMethodResponse copyOf) {
        Builder builder = OfflineMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.accountCustomer(copyOf.getAccountCustomer());
        builder.money(copyOf.getMoney());
        builder.moneyRequired(copyOf.getMoneyRequired().orElse(null));
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.processor(copyOf.getProcessor().orElse(null));
        builder.qrName(copyOf.getQrName().orElse(null));
        builder.qrCode(copyOf.getQrCode().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.productId(copyOf.getProductId().orElse(null));
        builder.taxId(copyOf.getTaxId().orElse(null));
        builder.taxIdCustomer(copyOf.getTaxIdCustomer().orElse(null));
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new OfflineMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder account(AccountResponseOffline var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder accountCustomer(AccountCustomerResponseOffline var1);

        public boolean isAccountCustomerDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder moneyRequired(MoneyRequired var1);

        public boolean isMoneyRequiredDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder processor(PaymentProcessor var1);

        public boolean isProcessorDefined();

        @NotNull
        public Builder qrName(String var1);

        public boolean isQrNameDefined();

        @NotNull
        public Builder qrCode(String var1);

        public boolean isQrCodeDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder paymentOperator(SelectedPaymentOperatorIncoming var1);

        public boolean isPaymentOperatorDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder productId(String var1);

        public boolean isProductIdDefined();

        @NotNull
        public Builder taxId(String var1);

        public boolean isTaxIdDefined();

        @NotNull
        public Builder taxIdCustomer(String var1);

        public boolean isTaxIdCustomerDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public OfflineMethodResponse build();
    }
}

