/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestVaPay;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.PaymentLocation;
import tech.carpentum.sdk.payment.model.VaPayMethod;

@JsonClass(generateAdapter=false)
public class VaPayMethodImpl
implements VaPayMethod {
    private final Optional<AccountPayinRequestVaPay> account;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<PaymentLocation> paymentLocation;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestVaPay> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<PaymentLocation> getPaymentLocation() {
        return this.paymentLocation;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private VaPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.paymentLocation = Optional.ofNullable(builder.paymentLocation);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress, this.phoneNumber, this.paymentLocation);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", paymentLocation=" + this.paymentLocation + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VaPayMethodImpl)) {
            return false;
        }
        VaPayMethodImpl that = (VaPayMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        return Objects.equals(this.paymentLocation, that.paymentLocation);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements VaPayMethod.Builder {
        private AccountPayinRequestVaPay account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private PaymentLocation paymentLocation = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("VaPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestVaPay account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl paymentLocation(PaymentLocation paymentLocation) {
            this.paymentLocation = paymentLocation;
            return this;
        }

        @Override
        public boolean isPaymentLocationDefined() {
            return this.paymentLocation != null;
        }

        @Override
        public VaPayMethodImpl build() {
            return new VaPayMethodImpl(this);
        }
    }
}

