/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.MoneyPaymentRequested;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentRequestedImpl
implements PaymentRequested {
    private final MoneyPaymentRequested money;
    private final Optional<SegmentCode> segmentCode;
    private final Optional<CurrencyCode> exchangedToCurrency;
    private final int hashCode;
    private final String toString;

    @Override
    public MoneyPaymentRequested getMoney() {
        return this.money;
    }

    @Override
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    @Override
    public Optional<CurrencyCode> getExchangedToCurrency() {
        return this.exchangedToCurrency;
    }

    private PaymentRequestedImpl(BuilderImpl builder) {
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.exchangedToCurrency = Optional.ofNullable(builder.exchangedToCurrency);
        this.hashCode = Objects.hash(this.money, this.segmentCode, this.exchangedToCurrency);
        this.toString = builder.type + "(money=" + this.money + ", segmentCode=" + this.segmentCode + ", exchangedToCurrency=" + this.exchangedToCurrency + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentRequestedImpl)) {
            return false;
        }
        PaymentRequestedImpl that = (PaymentRequestedImpl)obj;
        if (!Objects.equals(this.money, that.money)) {
            return false;
        }
        if (!Objects.equals(this.segmentCode, that.segmentCode)) {
            return false;
        }
        return Objects.equals(this.exchangedToCurrency, that.exchangedToCurrency);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentRequested.Builder {
        private MoneyPaymentRequested money = null;
        private SegmentCode segmentCode = null;
        private CurrencyCode exchangedToCurrency = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentRequested");
        }

        @Override
        public BuilderImpl money(MoneyPaymentRequested money) {
            this.money = money;
            return this;
        }

        @Override
        public boolean isMoneyDefined() {
            return this.money != null;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public boolean isSegmentCodeDefined() {
            return this.segmentCode != null;
        }

        @Override
        public BuilderImpl exchangedToCurrency(CurrencyCode exchangedToCurrency) {
            this.exchangedToCurrency = exchangedToCurrency;
            return this;
        }

        @Override
        public boolean isExchangedToCurrencyDefined() {
            return this.exchangedToCurrency != null;
        }

        @Override
        public PaymentRequestedImpl build() {
            return new PaymentRequestedImpl(this);
        }
    }
}

