/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.FpxMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestFpx;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface FpxMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.FPX;

    @NotNull
    public AccountPayinRequestFpx getAccount();

    @NotNull
    public String getPaymentOperatorCode();

    @NotNull
    public static Builder builder(FpxMethod copyOf) {
        Builder builder = FpxMethod.builder();
        builder.account(copyOf.getAccount());
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new FpxMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestFpx var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder paymentOperatorCode(String var1);

        public boolean isPaymentOperatorCodeDefined();

        @NotNull
        public FpxMethod build();
    }
}

