/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestTaxIdTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;
import tech.carpentum.sdk.payment.model.TaxPayerIdTransferMethod;

@JsonClass(generateAdapter=false)
public class TaxPayerIdTransferMethodImpl
implements TaxPayerIdTransferMethod {
    private final String taxId;
    private final Optional<AccountPayoutRequestTaxIdTransfer> account;
    private final int hashCode;
    private final String toString;

    @Override
    public String getTaxId() {
        return this.taxId;
    }

    @Override
    public Optional<AccountPayoutRequestTaxIdTransfer> getAccount() {
        return this.account;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private TaxPayerIdTransferMethodImpl(BuilderImpl builder) {
        this.taxId = Objects.requireNonNull(builder.taxId, "Property 'taxId' is required.");
        this.account = Optional.ofNullable(builder.account);
        this.hashCode = Objects.hash(this.taxId, this.account);
        this.toString = builder.type + "(taxId=" + this.taxId + ", account=" + this.account + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaxPayerIdTransferMethodImpl)) {
            return false;
        }
        TaxPayerIdTransferMethodImpl that = (TaxPayerIdTransferMethodImpl)obj;
        if (!Objects.equals(this.taxId, that.taxId)) {
            return false;
        }
        return Objects.equals(this.account, that.account);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements TaxPayerIdTransferMethod.Builder {
        private String taxId = null;
        private AccountPayoutRequestTaxIdTransfer account = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("TaxPayerIdTransferMethod");
        }

        @Override
        public BuilderImpl taxId(String taxId) {
            this.taxId = taxId;
            return this;
        }

        @Override
        public boolean isTaxIdDefined() {
            return this.taxId != null;
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestTaxIdTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public TaxPayerIdTransferMethodImpl build() {
            return new TaxPayerIdTransferMethodImpl(this);
        }
    }
}

