/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AbsaPayMethod;
import tech.carpentum.sdk.payment.model.AccountPayinRequestAbsaPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class AbsaPayMethodImpl
implements AbsaPayMethod {
    private final Optional<AccountPayinRequestAbsaPay> account;
    private final Optional<String> emailAddress;
    private final Optional<String> passportNumber;
    private final Optional<String> said;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestAbsaPay> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPassportNumber() {
        return this.passportNumber;
    }

    @Override
    public Optional<String> getSaid() {
        return this.said;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private AbsaPayMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.passportNumber = Optional.ofNullable(builder.passportNumber);
        this.said = Optional.ofNullable(builder.said);
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.passportNumber, this.said);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ", passportNumber=" + this.passportNumber + ", said=" + this.said + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbsaPayMethodImpl)) {
            return false;
        }
        AbsaPayMethodImpl that = (AbsaPayMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.passportNumber, that.passportNumber)) {
            return false;
        }
        return Objects.equals(this.said, that.said);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AbsaPayMethod.Builder {
        private AccountPayinRequestAbsaPay account = null;
        private String emailAddress = null;
        private String passportNumber = null;
        private String said = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AbsaPayMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestAbsaPay account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl passportNumber(String passportNumber) {
            this.passportNumber = passportNumber;
            return this;
        }

        @Override
        public boolean isPassportNumberDefined() {
            return this.passportNumber != null;
        }

        @Override
        public BuilderImpl said(String said) {
            this.said = said;
            return this;
        }

        @Override
        public boolean isSaidDefined() {
            return this.said != null;
        }

        @Override
        public AbsaPayMethodImpl build() {
            return new AbsaPayMethodImpl(this);
        }
    }
}

