/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.EmailTransferMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestEmailTransfer;
import tech.carpentum.sdk.payment.model.IdentifyingReference;
import tech.carpentum.sdk.payment.model.PayoutMethod;

@JsonClass(generateAdapter=false)
public interface EmailTransferMethod
extends PayoutMethod {
    public static final PayoutMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayoutMethod.PaymentMethodCode.EMAIL_TRANSFER;

    @NotNull
    public String getEmailAddress();

    @NotNull
    public Optional<AccountPayoutRequestEmailTransfer> getAccount();

    @NotNull
    public IdentifyingReference getIdentifyingReference();

    @NotNull
    public static Builder builder(EmailTransferMethod copyOf) {
        Builder builder = EmailTransferMethod.builder();
        builder.emailAddress(copyOf.getEmailAddress());
        builder.account(copyOf.getAccount().orElse(null));
        builder.identifyingReference(copyOf.getIdentifyingReference());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new EmailTransferMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder emailAddress(String var1);

        public boolean isEmailAddressDefined();

        @NotNull
        public Builder account(AccountPayoutRequestEmailTransfer var1);

        public boolean isAccountDefined();

        @NotNull
        public Builder identifyingReference(IdentifyingReference var1);

        public boolean isIdentifyingReferenceDefined();

        @NotNull
        public EmailTransferMethod build();
    }
}

