/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AvailablePayinOptionVariantCurrencyImpl;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodCode;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public interface AvailablePayinOptionVariantCurrency {
    @NotNull
    public PayinMethodCode getPaymentMethodCode();

    @NotNull
    public @NotNull List<@NotNull PaymentOperatorIncoming> getPaymentOperators();

    @NotNull
    public Optional<SegmentCode> getSegmentCode();

    @NotNull
    public Money getMoney();

    @NotNull
    public static Builder builder(AvailablePayinOptionVariantCurrency copyOf) {
        Builder builder = AvailablePayinOptionVariantCurrency.builder();
        builder.paymentMethodCode(copyOf.getPaymentMethodCode());
        builder.paymentOperators(copyOf.getPaymentOperators());
        builder.segmentCode(copyOf.getSegmentCode().orElse(null));
        builder.money(copyOf.getMoney());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AvailablePayinOptionVariantCurrencyImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentMethodCode(PayinMethodCode var1);

        public boolean isPaymentMethodCodeDefined();

        @NotNull
        public Builder paymentOperators(List<@NotNull PaymentOperatorIncoming> var1);

        @NotNull
        public Builder paymentOperatorsAdd(PaymentOperatorIncoming var1);

        @NotNull
        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorIncoming> var1);

        @NotNull
        public Builder segmentCode(SegmentCode var1);

        public boolean isSegmentCodeDefined();

        @NotNull
        public Builder money(Money var1);

        public boolean isMoneyDefined();

        @NotNull
        public AvailablePayinOptionVariantCurrency build();
    }
}

