/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PayinImpl;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@JsonClass(generateAdapter=false)
public interface Payin {
    @NotNull
    public PaymentRequested getPaymentRequested();

    @NotNull
    public PayinMethod getPaymentMethod();

    @NotNull
    public Optional<String> getCallbackUrl();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public Optional<String> getCustomerIp();

    @NotNull
    public static Builder builder(Payin copyOf) {
        Builder builder = Payin.builder();
        builder.paymentRequested(copyOf.getPaymentRequested());
        builder.paymentMethod(copyOf.getPaymentMethod());
        builder.callbackUrl(copyOf.getCallbackUrl().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.customerIp(copyOf.getCustomerIp().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PayinImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentRequested(PaymentRequested var1);

        public boolean isPaymentRequestedDefined();

        @NotNull
        public Builder paymentMethod(PayinMethod var1);

        public boolean isPaymentMethodDefined();

        @NotNull
        public Builder callbackUrl(String var1);

        public boolean isCallbackUrlDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder customerIp(String var1);

        public boolean isCustomerIpDefined();

        @NotNull
        public Payin build();
    }
}

