/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.UpiQRMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseUpiQR;
import tech.carpentum.sdk.payment.model.ExternalReference;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.MoneyPaymentResponse;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentProcessor;
import tech.carpentum.sdk.payment.model.SelectedPaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public interface UpiQRMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.UPIQR;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public Optional<AccountCustomerResponseUpiQR> getAccountCustomer();

    @NotNull
    public MoneyPaymentResponse getMoney();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getMerchantName();

    @NotNull
    public String getReference();

    @NotNull
    public Optional<ExternalReference> getExternalReference();

    @NotNull
    public Optional<PaymentProcessor> getProcessor();

    @NotNull
    public String getQrName();

    @NotNull
    public String getQrCode();

    @NotNull
    public Optional<String> getUpiQrDeepLink();

    @NotNull
    public Optional<SelectedPaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public Optional<String> getUpiId();

    @NotNull
    public Optional<String> getUpiIdCustomer();

    @NotNull
    public Optional<String> getPhoneNumber();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(UpiQRMethodResponse copyOf) {
        Builder builder = UpiQRMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.accountCustomer(copyOf.getAccountCustomer().orElse(null));
        builder.money(copyOf.getMoney());
        builder.vat(copyOf.getVat().orElse(null));
        builder.merchantName(copyOf.getMerchantName());
        builder.reference(copyOf.getReference());
        builder.externalReference(copyOf.getExternalReference().orElse(null));
        builder.processor(copyOf.getProcessor().orElse(null));
        builder.qrName(copyOf.getQrName());
        builder.qrCode(copyOf.getQrCode());
        builder.upiQrDeepLink(copyOf.getUpiQrDeepLink().orElse(null));
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.upiId(copyOf.getUpiId().orElse(null));
        builder.upiIdCustomer(copyOf.getUpiIdCustomer().orElse(null));
        builder.phoneNumber(copyOf.getPhoneNumber().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new UpiQRMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        public boolean isIdPayinDefined();

        @NotNull
        public Builder idPayment(IdPayment var1);

        public boolean isIdPaymentDefined();

        @NotNull
        public Builder accountCustomer(AccountCustomerResponseUpiQR var1);

        public boolean isAccountCustomerDefined();

        @NotNull
        public Builder money(MoneyPaymentResponse var1);

        public boolean isMoneyDefined();

        @NotNull
        public Builder vat(MoneyVat var1);

        public boolean isVatDefined();

        @NotNull
        public Builder merchantName(String var1);

        public boolean isMerchantNameDefined();

        @NotNull
        public Builder reference(String var1);

        public boolean isReferenceDefined();

        @NotNull
        public Builder externalReference(ExternalReference var1);

        public boolean isExternalReferenceDefined();

        @NotNull
        public Builder processor(PaymentProcessor var1);

        public boolean isProcessorDefined();

        @NotNull
        public Builder qrName(String var1);

        public boolean isQrNameDefined();

        @NotNull
        public Builder qrCode(String var1);

        public boolean isQrCodeDefined();

        @NotNull
        public Builder upiQrDeepLink(String var1);

        public boolean isUpiQrDeepLinkDefined();

        @NotNull
        public Builder paymentOperator(SelectedPaymentOperatorIncoming var1);

        public boolean isPaymentOperatorDefined();

        @NotNull
        public Builder upiId(String var1);

        public boolean isUpiIdDefined();

        @NotNull
        public Builder upiIdCustomer(String var1);

        public boolean isUpiIdCustomerDefined();

        @NotNull
        public Builder phoneNumber(String var1);

        public boolean isPhoneNumberDefined();

        @NotNull
        public Builder returnUrl(String var1);

        public boolean isReturnUrlDefined();

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        public boolean isAcceptedAtDefined();

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        public boolean isExpireAtDefined();

        @NotNull
        public UpiQRMethodResponse build();
    }
}

