/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.RedirectionImpl;

@JsonClass(generateAdapter=false)
public interface Redirection {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";

    @NotNull
    public String getMethod();

    @NotNull
    public String getUrl();

    @NotNull
    public Optional<String> getData();

    @NotNull
    public static Builder builder(Redirection copyOf) {
        Builder builder = Redirection.builder();
        builder.method(copyOf.getMethod());
        builder.url(copyOf.getUrl());
        builder.data(copyOf.getData().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new RedirectionImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder method(String var1);

        public boolean isMethodDefined();

        @NotNull
        public Builder url(String var1);

        public boolean isUrlDefined();

        @NotNull
        public Builder data(String var1);

        public boolean isDataDefined();

        @NotNull
        public Redirection build();
    }
}

