/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;

@JsonClass(generateAdapter=false)
public class PaymentOperatorOptionImpl
implements PaymentOperatorOption {
    private final String code;
    private final Optional<String> name;
    private final Boolean isAvailable;
    private final IntervalNumberTo transactionAmountLimit;
    private final int hashCode;
    private final String toString;

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public Optional<String> getName() {
        return this.name;
    }

    @Override
    public Boolean getIsAvailable() {
        return this.isAvailable;
    }

    @Override
    public IntervalNumberTo getTransactionAmountLimit() {
        return this.transactionAmountLimit;
    }

    private PaymentOperatorOptionImpl(BuilderImpl builder) {
        this.code = Objects.requireNonNull(builder.code, "Property 'code' is required.");
        this.name = Optional.ofNullable(builder.name);
        this.isAvailable = Objects.requireNonNull(builder.isAvailable, "Property 'isAvailable' is required.");
        this.transactionAmountLimit = Objects.requireNonNull(builder.transactionAmountLimit, "Property 'transactionAmountLimit' is required.");
        this.hashCode = Objects.hash(this.code, this.name, this.isAvailable, this.transactionAmountLimit);
        this.toString = builder.type + "(code=" + this.code + ", name=" + this.name + ", isAvailable=" + this.isAvailable + ", transactionAmountLimit=" + this.transactionAmountLimit + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentOperatorOptionImpl)) {
            return false;
        }
        PaymentOperatorOptionImpl that = (PaymentOperatorOptionImpl)obj;
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.isAvailable, that.isAvailable)) {
            return false;
        }
        return Objects.equals(this.transactionAmountLimit, that.transactionAmountLimit);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentOperatorOption.Builder {
        private String code = null;
        private String name = null;
        private Boolean isAvailable = null;
        private IntervalNumberTo transactionAmountLimit = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentOperatorOption");
        }

        @Override
        public BuilderImpl code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public boolean isCodeDefined() {
            return this.code != null;
        }

        @Override
        public BuilderImpl name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public boolean isNameDefined() {
            return this.name != null;
        }

        @Override
        public BuilderImpl isAvailable(Boolean isAvailable) {
            this.isAvailable = isAvailable;
            return this;
        }

        @Override
        public boolean isIsAvailableDefined() {
            return this.isAvailable != null;
        }

        @Override
        public BuilderImpl transactionAmountLimit(IntervalNumberTo transactionAmountLimit) {
            this.transactionAmountLimit = transactionAmountLimit;
            return this;
        }

        @Override
        public boolean isTransactionAmountLimitDefined() {
            return this.transactionAmountLimit != null;
        }

        @Override
        public PaymentOperatorOptionImpl build() {
            return new PaymentOperatorOptionImpl(this);
        }
    }
}

