/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestNetBanking;
import tech.carpentum.sdk.payment.model.NetBankingMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class NetBankingMethodImpl
implements NetBankingMethod {
    private final Optional<AccountPayinRequestNetBanking> account;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<String> paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<AccountPayinRequestNetBanking> getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private NetBankingMethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.phoneNumber, this.paymentOperatorCode);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", paymentOperatorCode=" + this.paymentOperatorCode + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetBankingMethodImpl)) {
            return false;
        }
        NetBankingMethodImpl that = (NetBankingMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        return Objects.equals(this.paymentOperatorCode, that.paymentOperatorCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements NetBankingMethod.Builder {
        private AccountPayinRequestNetBanking account = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private String paymentOperatorCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("NetBankingMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestNetBanking account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public boolean isPaymentOperatorCodeDefined() {
            return this.paymentOperatorCode != null;
        }

        @Override
        public NetBankingMethodImpl build() {
            return new NetBankingMethodImpl(this);
        }
    }
}

