/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestPayMe;
import tech.carpentum.sdk.payment.model.PayMeMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class PayMeMethodImpl
implements PayMeMethod {
    private final AccountPayinRequestPayMe account;
    private final Optional<String> emailAddress;
    private final Optional<String> phoneNumber;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestPayMe getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private PayMeMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.phoneNumber);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayMeMethodImpl)) {
            return false;
        }
        PayMeMethodImpl that = (PayMeMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        if (!Objects.equals(this.emailAddress, that.emailAddress)) {
            return false;
        }
        return Objects.equals(this.phoneNumber, that.phoneNumber);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PayMeMethod.Builder {
        private AccountPayinRequestPayMe account = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PayMeMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestPayMe account) {
            this.account = account;
            return this;
        }

        @Override
        public boolean isAccountDefined() {
            return this.account != null;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public boolean isEmailAddressDefined() {
            return this.emailAddress != null;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public boolean isPhoneNumberDefined() {
            return this.phoneNumber != null;
        }

        @Override
        public PayMeMethodImpl build() {
            return new PayMeMethodImpl(this);
        }
    }
}

