/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.SettlementPaymentOptionImpl;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.SettlementMethodCode;

@JsonClass(generateAdapter=false)
public interface SettlementPaymentOption {
    @NotNull
    public SettlementMethodCode getPaymentMethodCode();

    @NotNull
    public CurrencyCode getCurrencyCode();

    @NotNull
    public IntervalNumberTo getTransactionAmountLimit();

    @NotNull
    public Boolean getIsAvailable();

    @NotNull
    public @NotNull List<@NotNull PaymentOperatorOption> getPaymentOperators();

    @NotNull
    public static Builder builder(SettlementPaymentOption copyOf) {
        Builder builder = SettlementPaymentOption.builder();
        builder.paymentMethodCode(copyOf.getPaymentMethodCode());
        builder.currencyCode(copyOf.getCurrencyCode());
        builder.transactionAmountLimit(copyOf.getTransactionAmountLimit());
        builder.isAvailable(copyOf.getIsAvailable());
        builder.paymentOperators(copyOf.getPaymentOperators());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new SettlementPaymentOptionImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder paymentMethodCode(SettlementMethodCode var1);

        @NotNull
        public Builder currencyCode(CurrencyCode var1);

        @NotNull
        public Builder transactionAmountLimit(IntervalNumberTo var1);

        @NotNull
        public Builder isAvailable(Boolean var1);

        @NotNull
        public Builder paymentOperators(List<@NotNull PaymentOperatorOption> var1);

        @NotNull
        public Builder paymentOperatorsAdd(PaymentOperatorOption var1);

        @NotNull
        public Builder paymentOperatorsAddAll(List<@NotNull PaymentOperatorOption> var1);

        @NotNull
        public SettlementPaymentOption build();
    }
}

