/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.AbsaPayMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestAbsaPay;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface AbsaPayMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.ABSA_PAY;

    @NotNull
    public AccountPayinRequestAbsaPay getAccount();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public static Builder builder(AbsaPayMethod copyOf) {
        Builder builder = AbsaPayMethod.builder();
        builder.account(copyOf.getAccount());
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new AbsaPayMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestAbsaPay var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public AbsaPayMethod build();
    }
}

