/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CurrencyCode;
import tech.carpentum.sdk.payment.model.ForexRate;

@JsonClass(generateAdapter=false)
public class ForexRateImpl
implements ForexRate {
    private final CurrencyCode baseCurrencyCode;
    private final CurrencyCode quoteCurrencyCode;
    private final Optional<BigDecimal> buyRate;
    private final Optional<BigDecimal> sellRate;
    private final Optional<OffsetDateTime> validUpTo;
    private final int hashCode;
    private final String toString;

    @Override
    public CurrencyCode getBaseCurrencyCode() {
        return this.baseCurrencyCode;
    }

    @Override
    public CurrencyCode getQuoteCurrencyCode() {
        return this.quoteCurrencyCode;
    }

    @Override
    public Optional<BigDecimal> getBuyRate() {
        return this.buyRate;
    }

    @Override
    public Optional<BigDecimal> getSellRate() {
        return this.sellRate;
    }

    @Override
    public Optional<OffsetDateTime> getValidUpTo() {
        return this.validUpTo;
    }

    private ForexRateImpl(BuilderImpl builder) {
        this.baseCurrencyCode = Objects.requireNonNull(builder.baseCurrencyCode, "Property 'baseCurrencyCode' is required.");
        this.quoteCurrencyCode = Objects.requireNonNull(builder.quoteCurrencyCode, "Property 'quoteCurrencyCode' is required.");
        this.buyRate = Optional.ofNullable(builder.buyRate);
        this.sellRate = Optional.ofNullable(builder.sellRate);
        this.validUpTo = Optional.ofNullable(builder.validUpTo);
        this.hashCode = Objects.hash(this.baseCurrencyCode, this.quoteCurrencyCode, this.buyRate, this.sellRate, this.validUpTo);
        this.toString = builder.type + "(baseCurrencyCode=" + this.baseCurrencyCode + ", quoteCurrencyCode=" + this.quoteCurrencyCode + ", buyRate=" + this.buyRate + ", sellRate=" + this.sellRate + ", validUpTo=" + this.validUpTo + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ForexRateImpl)) {
            return false;
        }
        ForexRateImpl that = (ForexRateImpl)obj;
        if (!Objects.equals(this.baseCurrencyCode, that.baseCurrencyCode)) {
            return false;
        }
        if (!Objects.equals(this.quoteCurrencyCode, that.quoteCurrencyCode)) {
            return false;
        }
        if (!Objects.equals(this.buyRate, that.buyRate)) {
            return false;
        }
        if (!Objects.equals(this.sellRate, that.sellRate)) {
            return false;
        }
        return Objects.equals(this.validUpTo, that.validUpTo);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements ForexRate.Builder {
        private CurrencyCode baseCurrencyCode = null;
        private CurrencyCode quoteCurrencyCode = null;
        private BigDecimal buyRate = null;
        private BigDecimal sellRate = null;
        private OffsetDateTime validUpTo = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("ForexRate");
        }

        @Override
        public BuilderImpl baseCurrencyCode(CurrencyCode baseCurrencyCode) {
            this.baseCurrencyCode = baseCurrencyCode;
            return this;
        }

        @Override
        public BuilderImpl quoteCurrencyCode(CurrencyCode quoteCurrencyCode) {
            this.quoteCurrencyCode = quoteCurrencyCode;
            return this;
        }

        @Override
        public BuilderImpl buyRate(BigDecimal buyRate) {
            this.buyRate = buyRate;
            return this;
        }

        @Override
        public BuilderImpl sellRate(BigDecimal sellRate) {
            this.sellRate = sellRate;
            return this;
        }

        @Override
        public BuilderImpl validUpTo(OffsetDateTime validUpTo) {
            this.validUpTo = validUpTo;
            return this;
        }

        @Override
        public ForexRateImpl build() {
            return new ForexRateImpl(this);
        }
    }
}

