/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOptionImpl;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOptionJson;
import tech.carpentum.sdk.payment.model.PaymentOperatorOption;
import tech.carpentum.sdk.payment.model.PaymentOption;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000bH\u0007\u00a8\u0006\u000e"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/PaymentOptionJsonAdapter;", "", "<init>", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/PaymentOption;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/PaymentOptionJson;", "toJson", "model", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/PaymentOptionImpl;", "toJsonImpl", "impl", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nPaymentOptionJsonAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentOptionJsonAdapter.kt\ntech/carpentum/sdk/payment/internal/generated/model/PaymentOptionJsonAdapter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class PaymentOptionJsonAdapter {
    @FromJson
    @NotNull
    public final PaymentOption fromJson(@NotNull PaymentOptionJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        PaymentOption.Builder builder = PaymentOption.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        PaymentOption.Builder builder2 = builder;
        builder2.paymentTypeCode(json.getPaymentTypeCode());
        builder2.paymentMethodCode(json.getPaymentMethodCode());
        builder2.currencyCode(json.getCurrencyCode());
        builder2.segmentCode(json.getSegmentCode());
        builder2.transactionAmountLimit(json.getTransactionAmountLimit());
        builder2.isAvailable(json.isAvailable());
        List<PaymentOperatorOption> list = json.getPaymentOperators();
        builder2.paymentOperators(list != null ? CollectionsKt.toList((Iterable)list) : null);
        PaymentOption paymentOption = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)paymentOption, (String)"build(...)");
        return paymentOption;
    }

    @ToJson
    @NotNull
    public final PaymentOptionJson toJson(@NotNull PaymentOption model) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        PaymentOptionJson json = new PaymentOptionJson();
        json.setPaymentTypeCode(model.getPaymentTypeCode());
        json.setPaymentMethodCode(model.getPaymentMethodCode());
        json.setCurrencyCode(model.getCurrencyCode());
        json.setSegmentCode(model.getSegmentCode().orElse(null));
        json.setTransactionAmountLimit(model.getTransactionAmountLimit());
        json.setAvailable(model.getIsAvailable());
        PaymentOptionJson paymentOptionJson = json;
        Collection collection2 = model.getPaymentOperators();
        if (collection2.isEmpty()) {
            PaymentOptionJson paymentOptionJson2 = paymentOptionJson;
            boolean bl = false;
            collection = null;
            paymentOptionJson = paymentOptionJson2;
        } else {
            collection = collection2;
        }
        paymentOptionJson.setPaymentOperators((List)collection);
        return json;
    }

    @FromJson
    @NotNull
    public final PaymentOptionImpl fromJsonImpl(@NotNull PaymentOption model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (PaymentOptionImpl)model;
    }

    @ToJson
    @NotNull
    public final PaymentOption toJsonImpl(@NotNull PaymentOptionImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

