/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.api;

import com.squareup.moshi.Json;
import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.generated.api.PaymentsApi;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClient;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseType;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerException;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;
import tech.carpentum.sdk.payment.model.CurrencyList;
import tech.carpentum.sdk.payment.model.PaymentMethodsList;
import tech.carpentum.sdk.payment.model.PaymentOperatorList;
import tech.carpentum.sdk.payment.model.PaymentOptionsList;
import tech.carpentum.sdk.payment.model.SegmentList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000f2\u0006\u0010\t\u001a\u00020\nJ@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003JF\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003JH\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u000f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006("}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi;", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "basePath", "", "client", "Lokhttp3/OkHttpClient;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;)V", "getCurrencies", "Ltech/carpentum/sdk/payment/model/CurrencyList;", "xAPIVersion", "", "getCurrenciesRequestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "", "getCurrenciesWithHttpInfo", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiResponse;", "getPaymentMethods", "Ltech/carpentum/sdk/payment/model/PaymentMethodsList;", "getPaymentMethodsRequestConfig", "getPaymentMethodsWithHttpInfo", "getPaymentOperators", "Ltech/carpentum/sdk/payment/model/PaymentOperatorList;", "getPaymentOperatorsRequestConfig", "getPaymentOperatorsWithHttpInfo", "getPaymentOptions", "Ltech/carpentum/sdk/payment/model/PaymentOptionsList;", "paymentTypeCode", "Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$PaymentTypeCode_getPaymentOptions;", "paymentMethodCodes", "currencyCodes", "segmentCodes", "paymentOperatorCodes", "getPaymentOptionsRequestConfig", "getPaymentOptionsWithHttpInfo", "getSegments", "Ltech/carpentum/sdk/payment/model/SegmentList;", "getSegmentsRequestConfig", "getSegmentsWithHttpInfo", "Companion", "PaymentTypeCode_getPaymentOptions", "payment-client-v2"})
@SourceDebugExtension(value={"SMAP\nPaymentsApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/PaymentsApi\n+ 2 ApiClient.kt\ntech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 -MoshiKotlinExtensions.kt\ncom/squareup/moshi/_MoshiKotlinExtensionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n148#2,9:455\n157#2:465\n158#2,2:467\n160#2:470\n161#2,24:472\n62#2,51:496\n185#2,3:547\n62#2,51:550\n188#2:601\n62#2,51:602\n189#2:653\n62#2,51:654\n190#2,22:705\n116#2,19:727\n135#2:747\n212#2,14:748\n148#2,9:763\n157#2:773\n158#2,2:775\n160#2:778\n161#2,24:780\n62#2,51:804\n185#2,3:855\n62#2,51:858\n188#2:909\n62#2,51:910\n189#2:961\n62#2,51:962\n190#2,22:1013\n116#2,19:1035\n135#2:1055\n212#2,14:1056\n148#2,9:1070\n157#2:1080\n158#2,2:1082\n160#2:1085\n161#2,24:1087\n62#2,51:1111\n185#2,3:1162\n62#2,51:1165\n188#2:1216\n62#2,51:1217\n189#2:1268\n62#2,51:1269\n190#2,22:1320\n116#2,19:1342\n135#2:1362\n212#2,14:1363\n148#2,9:1377\n157#2:1387\n158#2,2:1389\n160#2:1392\n161#2,24:1394\n62#2,51:1418\n185#2,3:1469\n62#2,51:1472\n188#2:1523\n62#2,51:1524\n189#2:1575\n62#2,51:1576\n190#2,22:1627\n116#2,19:1649\n135#2:1669\n212#2,14:1670\n148#2,9:1684\n157#2:1694\n158#2,2:1696\n160#2:1699\n161#2,24:1701\n62#2,51:1725\n185#2,3:1776\n62#2,51:1779\n188#2:1830\n62#2,51:1831\n189#2:1882\n62#2,51:1883\n190#2,22:1934\n116#2,19:1956\n135#2:1976\n212#2,14:1977\n215#3:464\n216#3:471\n215#3:772\n216#3:779\n215#3:1079\n216#3:1086\n215#3:1386\n216#3:1393\n215#3:1693\n216#3:1700\n1855#4:466\n1856#4:469\n1855#4:774\n1856#4:777\n1855#4:1081\n1856#4:1084\n1855#4:1388\n1856#4:1391\n1855#4:1695\n1856#4:1698\n29#5:746\n29#5:1054\n29#5:1361\n29#5:1668\n29#5:1975\n1#6:762\n*S KotlinDebug\n*F\n+ 1 PaymentsApi.kt\ntech/carpentum/sdk/payment/internal/generated/api/PaymentsApi\n*L\n100#1:455,9\n100#1:465\n100#1:467,2\n100#1:470\n100#1:472,24\n100#1:496,51\n100#1:547,3\n100#1:550,51\n100#1:601\n100#1:602,51\n100#1:653\n100#1:654,51\n100#1:705,22\n100#1:727,19\n100#1:747\n100#1:748,14\n171#1:763,9\n171#1:773\n171#1:775,2\n171#1:778\n171#1:780,24\n171#1:804,51\n171#1:855,3\n171#1:858,51\n171#1:909\n171#1:910,51\n171#1:961\n171#1:962,51\n171#1:1013,22\n171#1:1035,19\n171#1:1055\n171#1:1056,14\n242#1:1070,9\n242#1:1080\n242#1:1082,2\n242#1:1085\n242#1:1087,24\n242#1:1111,51\n242#1:1162,3\n242#1:1165,51\n242#1:1216\n242#1:1217,51\n242#1:1268\n242#1:1269,51\n242#1:1320,22\n242#1:1342,19\n242#1:1362\n242#1:1363,14\n333#1:1377,9\n333#1:1387\n333#1:1389,2\n333#1:1392\n333#1:1394,24\n333#1:1418,51\n333#1:1469,3\n333#1:1472,51\n333#1:1523\n333#1:1524,51\n333#1:1575\n333#1:1576,51\n333#1:1627,22\n333#1:1649,19\n333#1:1669\n333#1:1670,14\n426#1:1684,9\n426#1:1694\n426#1:1696,2\n426#1:1699\n426#1:1701,24\n426#1:1725,51\n426#1:1776,3\n426#1:1779,51\n426#1:1830\n426#1:1831,51\n426#1:1882\n426#1:1883,51\n426#1:1934,22\n426#1:1956,19\n426#1:1976\n426#1:1977,14\n100#1:464\n100#1:471\n171#1:772\n171#1:779\n242#1:1079\n242#1:1086\n333#1:1386\n333#1:1393\n426#1:1693\n426#1:1700\n100#1:466\n100#1:469\n171#1:774\n171#1:777\n242#1:1081\n242#1:1084\n333#1:1388\n333#1:1391\n426#1:1695\n426#1:1698\n100#1:746\n171#1:1054\n242#1:1361\n333#1:1668\n426#1:1975\n*E\n"})
public class PaymentsApi
extends ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<String> defaultBasePath$delegate = LazyKt.lazy((Function0)Companion.defaultBasePath.2.INSTANCE);

    public PaymentsApi(@NotNull String basePath, @NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        super(basePath, client);
    }

    public /* synthetic */ PaymentsApi(String string, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = Companion.getDefaultBasePath();
        }
        this(string, okHttpClient);
    }

    @NotNull
    public final CurrencyList getCurrencies(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<CurrencyList> localVarResponse = this.getCurrenciesWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.CurrencyList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (CurrencyList)t;
    }

    @NotNull
    public final ApiResponse<CurrencyList> getCurrenciesWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getCurrenciesRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(CurrencyList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (CurrencyList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(CurrencyList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getCurrenciesRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getCurrenciesRequestConfig_u24lambda_u240 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getCurrenciesRequestConfig_u24lambda_u240));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/currencies", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentMethodsList getPaymentMethods(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentMethodsList> localVarResponse = this.getPaymentMethodsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentMethodsList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentMethodsList)t;
    }

    @NotNull
    public final ApiResponse<PaymentMethodsList> getPaymentMethodsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentMethodsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(PaymentMethodsList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (PaymentMethodsList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PaymentMethodsList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentMethodsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentMethodsRequestConfig_u24lambda_u241 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentMethodsRequestConfig_u24lambda_u241));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-methods", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentOperatorList getPaymentOperators(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentOperatorList> localVarResponse = this.getPaymentOperatorsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentOperatorList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentOperatorList)t;
    }

    @NotNull
    public final ApiResponse<PaymentOperatorList> getPaymentOperatorsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentOperatorsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(PaymentOperatorList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (PaymentOperatorList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PaymentOperatorList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentOperatorsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentOperatorsRequestConfig_u24lambda_u242 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentOperatorsRequestConfig_u24lambda_u242));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-operators", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final PaymentOptionsList getPaymentOptions(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<PaymentOptionsList> localVarResponse = this.getPaymentOptionsWithHttpInfo(xAPIVersion, paymentTypeCode, paymentMethodCodes, currencyCodes, segmentCodes, paymentOperatorCodes);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.PaymentOptionsList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (PaymentOptionsList)t;
    }

    @NotNull
    public final ApiResponse<PaymentOptionsList> getPaymentOptionsWithHttpInfo(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getPaymentOptionsRequestConfig(xAPIVersion, paymentTypeCode, paymentMethodCodes, currencyCodes, segmentCodes, paymentOperatorCodes);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(PaymentOptionsList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (PaymentOptionsList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(PaymentOptionsList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getPaymentOptionsRequestConfig(int xAPIVersion, @Nullable PaymentTypeCode_getPaymentOptions paymentTypeCode, @Nullable String paymentMethodCodes, @Nullable String currencyCodes, @Nullable String segmentCodes, @Nullable String paymentOperatorCodes) {
        int n;
        Map map;
        Object localVariableBody = null;
        Map $this$getPaymentOptionsRequestConfig_u24lambda_u243 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        if (paymentTypeCode != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u243.put("paymentTypeCode", CollectionsKt.listOf((Object)paymentTypeCode.toString()));
        }
        if (paymentMethodCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u243.put("paymentMethodCodes", CollectionsKt.listOf((Object)paymentMethodCodes.toString()));
        }
        if (currencyCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u243.put("currencyCodes", CollectionsKt.listOf((Object)currencyCodes.toString()));
        }
        if (segmentCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u243.put("segmentCodes", CollectionsKt.listOf((Object)segmentCodes.toString()));
        }
        if (paymentOperatorCodes != null) {
            $this$getPaymentOptionsRequestConfig_u24lambda_u243.put("paymentOperatorCodes", CollectionsKt.listOf((Object)paymentOperatorCodes.toString()));
        }
        Map localVariableQuery = map;
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getPaymentOptionsRequestConfig_u24lambda_u244 = n = xAPIVersion;
        boolean bl2 = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getPaymentOptionsRequestConfig_u24lambda_u244));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/payment-options", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public final SegmentList getSegments(int xAPIVersion) throws IllegalStateException, IOException, UnsupportedOperationException, ClientException, ServerException {
        Object t;
        ApiResponse<SegmentList> localVarResponse = this.getSegmentsWithHttpInfo(xAPIVersion);
        switch (WhenMappings.$EnumSwitchMapping$0[localVarResponse.getResponseType().ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.Success<*>");
                t = ((Success)localVarResponse).getData();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.model.SegmentList");
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Client does not support Informational responses.");
            }
            case 3: {
                throw new UnsupportedOperationException("Client does not support Redirection responses.");
            }
            case 4: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError<*>");
                ClientError localVarError = (ClientError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ClientException("Client error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            case 5: {
                Intrinsics.checkNotNull(localVarResponse, (String)"null cannot be cast to non-null type tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError<*>");
                ServerError localVarError = (ServerError)localVarResponse;
                int n = localVarError.getStatusCode();
                String string = localVarError.getMessage();
                if (string == null) {
                    string = "";
                }
                throw new ServerException("Server error : " + n + " " + string, localVarError.getStatusCode(), localVarResponse);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (SegmentList)t;
    }

    @NotNull
    public final ApiResponse<SegmentList> getSegmentsWithHttpInfo(int xAPIVersion) throws IllegalStateException, IOException {
        ApiResponse apiResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers$iv;
        Unit element$iv$iv;
        RequestConfig<Unit> localVariableConfig = this.getSegmentsRequestConfig(xAPIVersion);
        ApiClient this_$iv = this;
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this_$iv.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl$iv = httpUrl;
        ApiClient.access$updateAuthParams(this_$iv, localVariableConfig);
        Object object = new char[]{'/'};
        Object $this$request_u24lambda_u247$iv = object = (Object)httpUrl$iv.newBuilder().addPathSegments(StringsKt.trimStart((String)localVariableConfig.getPath(), (char[])object));
        boolean $i$a$-apply-ApiClient$request$url$1$iv22 = false;
        Request.Builder $this$forEach$iv$iv = localVariableConfig.getQuery();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Unit query$iv = element$iv$iv = object2.next();
            boolean bl6 = false;
            Iterable $this$forEach$iv$iv2 = query$iv.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv$iv2 : $this$forEach$iv$iv2) {
                String queryValue$iv = (String)element$iv$iv2;
                boolean bl2 = false;
                $this$request_u24lambda_u247$iv.addQueryParameter(query$iv.getKey(), queryValue$iv);
            }
        }
        HttpUrl url$iv = object.build();
        object = localVariableConfig.getHeaders().get("Content-Type");
        if (object == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Content-Type", "application/json");
        }
        if ((object = (CharSequence)localVariableConfig.getHeaders().get("Accept")) == null || object.length() == 0) {
            localVariableConfig.getHeaders().put("Accept", "application/json");
        }
        if (($this$request_u24lambda_u247$iv = (Object)(headers$iv = localVariableConfig.getHeaders()).get("Content-Type")) == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        $this$request_u24lambda_u247$iv = headers$iv.get("Accept");
        if ($this$request_u24lambda_u247$iv == null || $this$request_u24lambda_u247$iv.length() == 0) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string2 = headers$iv.get("Content-Type");
        Intrinsics.checkNotNull((Object)string2, (String)"null cannot be cast to non-null type kotlin.String");
        String $i$a$-apply-ApiClient$request$url$1$iv22 = StringsKt.substringBefore$default((String)string2, (String)";", null, (int)2, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = $i$a$-apply-ApiClient$request$url$1$iv22.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
        String contentType$iv = string3;
        switch (ApiClient.WhenMappings.$EnumSwitchMapping$0[localVariableConfig.getMethod().ordinal()]) {
            case 1: {
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                ApiClient this_$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                RequestBody requestBody;
                Unit content$iv$iv;
                object2 = this_$iv;
                element$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv$iv$iv;
                        entry = element$iv$iv$iv = iterator.next();
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(stringArray);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string4 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string4, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.delete(requestBody);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url$iv);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url$iv).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach5 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach6 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string5 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string5, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.patch(requestBody);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach7 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach8 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string6 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string6, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.put(requestBody);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl;
                boolean bl3;
                FormBody.Builder $this$requestBody_u24lambda_u243$iv$iv;
                String[] fileMediaType$iv$iv;
                Headers partHeaders$iv$iv;
                String[] stringArray;
                Object value$iv$iv;
                String key$iv$iv;
                boolean bl4;
                Map.Entry entry;
                Map $this$forEach$iv$iv$iv;
                boolean bl5;
                MultipartBody.Builder $this$requestBody_u24lambda_u241$iv$iv;
                ApiClient this_$iv$iv = this_$iv;
                Unit content$iv$iv = localVariableConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url$iv);
                boolean $i$f$requestBody = false;
                if (content$iv$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv$iv, MediaType.Companion.parse(contentType$iv));
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"multipart/form-data")) {
                    MultipartBody.Builder bl6;
                    $this$requestBody_u24lambda_u241$iv$iv = bl6 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    bl5 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach9 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl4 = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        if (value$iv$iv instanceof File) {
                            fileMediaType$iv$iv = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\"; filename=\"" + ((File)value$iv$iv).getName() + "\""};
                            partHeaders$iv$iv = Headers.Companion.of(fileMediaType$iv$iv);
                            fileMediaType$iv$iv = MediaType.Companion.parse(ApiClient.access$guessContentTypeFromFile(this_$iv$iv, (File)value$iv$iv));
                            $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create((File)value$iv$iv, (MediaType)fileMediaType$iv$iv));
                            continue;
                        }
                        stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv$iv + "\""};
                        partHeaders$iv$iv = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u241$iv$iv.addPart(partHeaders$iv$iv, RequestBody.Companion.create(ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv), null));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/x-www-form-urlencoded")) {
                    FormBody.Builder bl6;
                    $this$requestBody_u24lambda_u243$iv$iv = bl6 = new FormBody.Builder(null, 1, null);
                    bl3 = false;
                    Intrinsics.checkNotNull((Object)content$iv$iv, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    $this$forEach$iv$iv$iv = (Map)content$iv$iv;
                    boolean $i$f$forEach10 = false;
                    for (Map.Entry element$iv$iv$iv : $this$forEach$iv$iv$iv.entrySet()) {
                        entry = element$iv$iv$iv;
                        bl = false;
                        key$iv$iv = (String)entry.getKey();
                        value$iv$iv = entry.getValue();
                        $this$requestBody_u24lambda_u243$iv$iv.add(key$iv$iv, ApiClient.access$parameterToString(this_$iv$iv, value$iv$iv));
                    }
                    requestBody = (RequestBody)bl6.build();
                } else if (StringsKt.startsWith$default((String)contentType$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)contentType$iv, (String)"json", (boolean)false, (int)2, null)) {
                    if (content$iv$iv == null) {
                        requestBody = Util.EMPTY_REQUEST;
                    } else {
                        String string7 = Serializer.getMoshi().adapter(Unit.class).toJson((Object)content$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toJson(...)");
                        requestBody = RequestBody.Companion.create(string7, MediaType.Companion.parse(contentType$iv));
                    }
                } else {
                    if (Intrinsics.areEqual((Object)contentType$iv, (Object)"application/xml")) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                builder = builder2.post(requestBody);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url$iv).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Request.Builder $this$request_u24lambda_u249$iv = $this$forEach$iv$iv = builder;
        boolean bl8 = false;
        Map<String, String> $this$forEach$iv$iv3 = headers$iv;
        boolean $i$f$forEach112 = false;
        Iterator<Map.Entry<String, String>> bl6 = $this$forEach$iv$iv3.entrySet().iterator();
        while (bl6.hasNext()) {
            Map.Entry<String, String> element$iv$iv3;
            Map.Entry<String, String> header$iv = element$iv$iv3 = bl6.next();
            boolean bl7 = false;
            $this$request_u24lambda_u249$iv.addHeader(header$iv.getKey(), header$iv.getValue());
        }
        Request request$iv = $this$forEach$iv$iv.build();
        Response response$iv = this_$iv.getClient().newCall(request$iv).execute();
        String string8 = Response.header$default((Response)response$iv, (String)"Content-Type", null, (int)2, null);
        if (string8 != null && (string8 = StringsKt.substringBefore$default((String)string8, (String)";", null, (int)2, null)) != null) {
            String $i$f$forEach112 = string8;
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
            String string9 = $i$f$forEach112.toLowerCase(locale2);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"this as java.lang.String).toLowerCase(locale)");
        } else {
            string = null;
        }
        String accept$iv = string;
        if (response$iv.isRedirect()) {
            apiResponse = new Redirection(response$iv.code(), response$iv.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response$iv)) {
            apiResponse = new Informational(response$iv.message(), response$iv.code(), response$iv.headers().toMultimap());
        } else if (response$iv.isSuccessful()) {
            Object object3;
            ApiClient bl8 = this_$iv;
            ResponseBody body$iv$iv = response$iv.body();
            boolean $i$f$responseBody = false;
            if (body$iv$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv$iv = body$iv$iv.string();
                if (((CharSequence)bodyContent$iv$iv).length() == 0) {
                    object3 = null;
                } else if (Intrinsics.areEqual(SegmentList.class, File.class)) {
                    File f$iv$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                    f$iv$iv.deleteOnExit();
                    BufferedWriter out$iv$iv = new BufferedWriter(new FileWriter(f$iv$iv));
                    out$iv$iv.write(bodyContent$iv$iv);
                    out$iv$iv.close();
                    object3 = (SegmentList)((Object)f$iv$iv);
                } else if (accept$iv == null || StringsKt.startsWith$default((String)accept$iv, (String)"application/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)accept$iv, (String)"json", (boolean)false, (int)2, null)) {
                    Moshi $this$adapter$iv$iv$iv = Serializer.getMoshi();
                    boolean $i$f$adapter = false;
                    object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv$iv, (KType)Reflection.nullableTypeOf(SegmentList.class)).fromJson(bodyContent$iv$iv);
                } else {
                    throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                }
            }
            apiResponse = new Success<Object>(object3, response$iv.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response$iv.headers().toMultimap()));
        } else if (ResponseExtensionsKt.isClientError(response$iv)) {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ClientError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        } else {
            ResponseBody responseBody = response$iv.body();
            apiResponse = new ServerError(response$iv.message(), responseBody != null ? responseBody.string() : null, response$iv.code(), response$iv.headers().toMultimap());
        }
        return apiResponse;
    }

    @NotNull
    public final RequestConfig<Unit> getSegmentsRequestConfig(int xAPIVersion) {
        int n;
        Object localVariableBody = null;
        Map localVariableQuery = new LinkedHashMap();
        Map localVariableHeaders = new LinkedHashMap();
        int $this$getSegmentsRequestConfig_u24lambda_u245 = n = xAPIVersion;
        boolean bl = false;
        localVariableHeaders.put("X-API-Version", String.valueOf($this$getSegmentsRequestConfig_u24lambda_u245));
        localVariableHeaders.put("Accept", "application/json");
        RequestMethod requestMethod = RequestMethod.GET;
        return new RequestConfig<Object>(requestMethod, "/segments", localVariableHeaders, localVariableQuery, localVariableBody);
    }

    @NotNull
    public static final String getDefaultBasePath() {
        return Companion.getDefaultBasePath();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$Companion;", "", "()V", "defaultBasePath", "", "getDefaultBasePath$annotations", "getDefaultBasePath", "()Ljava/lang/String;", "defaultBasePath$delegate", "Lkotlin/Lazy;", "payment-client-v2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultBasePath() {
            Lazy lazy = defaultBasePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (String)object;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultBasePath$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/api/PaymentsApi$PaymentTypeCode_getPaymentOptions;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "PAYIN", "PAYOUT", "TOPUP_WALLET", "payment-client-v2"})
    public static final class PaymentTypeCode_getPaymentOptions
    extends Enum<PaymentTypeCode_getPaymentOptions> {
        @NotNull
        private final String value;
        @Json(name="PAYIN")
        public static final /* enum */ PaymentTypeCode_getPaymentOptions PAYIN = new PaymentTypeCode_getPaymentOptions("PAYIN");
        @Json(name="PAYOUT")
        public static final /* enum */ PaymentTypeCode_getPaymentOptions PAYOUT = new PaymentTypeCode_getPaymentOptions("PAYOUT");
        @Json(name="TOPUP_WALLET")
        public static final /* enum */ PaymentTypeCode_getPaymentOptions TOPUP_WALLET = new PaymentTypeCode_getPaymentOptions("TOPUP_WALLET");
        private static final /* synthetic */ PaymentTypeCode_getPaymentOptions[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PaymentTypeCode_getPaymentOptions(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static PaymentTypeCode_getPaymentOptions[] values() {
            return (PaymentTypeCode_getPaymentOptions[])$VALUES.clone();
        }

        public static PaymentTypeCode_getPaymentOptions valueOf(String value) {
            return Enum.valueOf(PaymentTypeCode_getPaymentOptions.class, value);
        }

        @NotNull
        public static EnumEntries<PaymentTypeCode_getPaymentOptions> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = paymentTypeCode_getPaymentOptionsArray = new PaymentTypeCode_getPaymentOptions[]{PaymentTypeCode_getPaymentOptions.PAYIN, PaymentTypeCode_getPaymentOptions.PAYOUT, PaymentTypeCode_getPaymentOptions.TOPUP_WALLET};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseType.values().length];
            try {
                nArray[ResponseType.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.Redirection.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ClientError.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseType.ServerError.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

