/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.EndpointDefinition;

public class AuthTokenOperations
implements Supplier<List<String>> {
    private final Set<String> grants = new HashSet<String>();

    public AuthTokenOperations() {
    }

    public AuthTokenOperations(@NotNull EndpointDefinition definition) {
        this();
        this.grant(definition);
    }

    @NotNull
    private AuthTokenOperations grant(@NotNull EndpointDefinition.Method method, @NotNull String resource) {
        this.grants.add(method + " " + resource);
        return this;
    }

    @NotNull
    public AuthTokenOperations grant(@NotNull EndpointDefinition definition) {
        return this.grant(definition.getMethod(), definition.getResource());
    }

    @NotNull
    public AuthTokenOperations grantGet(@NotNull String resource) {
        return this.grant(EndpointDefinition.Method.GET, resource);
    }

    @NotNull
    public AuthTokenOperations grantPost(@NotNull String resource) {
        return this.grant(EndpointDefinition.Method.POST, resource);
    }

    @Override
    @NotNull
    public List<String> get() {
        return new ArrayList<String>(this.grants);
    }
}

