/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestIMPS;
import tech.carpentum.sdk.payment.model.IMPSMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class IMPSMethodImpl
implements IMPSMethod {
    private final AccountPayinRequestIMPS account;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestIMPS getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private IMPSMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.emailAddress);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IMPSMethodImpl)) {
            return false;
        }
        IMPSMethodImpl that = (IMPSMethodImpl)obj;
        if (!Objects.equals(this.account, that.account)) {
            return false;
        }
        return Objects.equals(this.emailAddress, that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements IMPSMethod.Builder {
        private AccountPayinRequestIMPS account = null;
        private String emailAddress = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("IMPSMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestIMPS account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public IMPSMethodImpl build() {
            return new IMPSMethodImpl(this);
        }
    }
}

