/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayoutRequestWalletTransfer;
import tech.carpentum.sdk.payment.model.PayoutMethod;
import tech.carpentum.sdk.payment.model.WalletTransferMethod;

@JsonClass(generateAdapter=false)
public class WalletTransferMethodImpl
implements WalletTransferMethod {
    private final AccountPayoutRequestWalletTransfer account;
    private final Optional<String> paymentOperatorCode;
    private final Optional<String> phoneNumber;
    private final Optional<String> remark;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayoutRequestWalletTransfer getAccount() {
        return this.account;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getRemark() {
        return this.remark;
    }

    @Override
    public PayoutMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private WalletTransferMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.remark = Optional.ofNullable(builder.remark);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.phoneNumber, this.remark);
        this.toString = builder.type + "(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", phoneNumber=" + this.phoneNumber + ", remark=" + this.remark + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WalletTransferMethodImpl)) {
            return false;
        }
        WalletTransferMethodImpl that = (WalletTransferMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        return this.remark.equals(that.remark);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements WalletTransferMethod.Builder {
        private AccountPayoutRequestWalletTransfer account = null;
        private String paymentOperatorCode = null;
        private String phoneNumber = null;
        private String remark = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("WalletTransferMethod");
        }

        @Override
        public BuilderImpl account(AccountPayoutRequestWalletTransfer account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl remark(String remark) {
            this.remark = remark;
            return this;
        }

        @Override
        public WalletTransferMethodImpl build() {
            return new WalletTransferMethodImpl(this);
        }
    }
}

